package com.dst.slms.base.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.base.entity.SalesProgressInfo;
import com.dst.slms.base.service.ISalesProgressService;

/**   
 * 销售进度 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 销售进度
 * @author 
 * @date 2020-05-07 10:39:17
 * @version V1.0   
 *
 */
public abstract class AbstractSalesProgressController extends CoreBaseController {

	@Autowired
	private ISalesProgressService iSalesProgressService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/base/salesprogress/salesProgressList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/base/salesprogress/salesProgressEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iSalesProgressService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		SalesProgressInfo info = new SalesProgressInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("isEnable");
		sic.add("org.id");
		sic.add("org.number");
		sic.add("org.name");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("salesProgress");
		sic.add("year");
		return sic;
	}
	
	@RequiresPermissions("sas:salesProgress:list")		
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(SalesProgressInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}

	@SysPermissionName(name="列表查看")
	@RequiresPermissions("sas:salesProgress:list")	
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("sas:salesProgress:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}
	
	@SysPermissionName(name="表单查看")
	@RequiresPermissions("sas:salesProgress:view")	
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(SalesProgressInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("sas:salesProgress:edit")
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(SalesProgressInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("sas:salesProgress:save")
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(SalesProgressInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}
	
	@SysPermissionName(name="提交")
	@RequiresPermissions("sas:salesProgress:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(SalesProgressInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}
	
	@SysPermissionName(name="删除")
	@RequiresPermissions("sas:salesProgress:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(SalesProgressInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("sas:salesProgress:downExcel")
	@RequestMapping(value = "/downExcel")
	public void downExcel(SalesProgressInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
