<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/common/common.jsp"%>
<head>
<Dst:SMBase type="jquery,eui" pakgagePath="com.dst.slms.plan.projectyearbudget.projectYearBudgetEdit" uipk="projectYearBudgetController" title="项目年度预算"/>
</head>
<body class="dst-mainbackground">
<div class="dst-container">

<Dst:SMMain title="项目年度预算">
	<Dst:SMEDBillToolBar >
	   <Dst:SMDGToolBar title="保存" icon="fa fa-save" bindAction="saveAction"/>
	   <Dst:SMDGToolBar title="提交并关闭" icon="fa fa-clipboard" bindAction="submitAction"/>
	   <Dst:SMDGToolBar title="查看流程图" icon="fa fa-cubes" bindAction="viewFlowAction"/>
	   <Dst:SMDGToolBar title="关闭" icon="fa fa-rotate-left" bindAction="closeAction"/>
	</Dst:SMEDBillToolBar> 
	<Dst:SMForm formid="formobj" >
		<input id="id" name="id" type="hidden" value="${model.id }">
		<input id="oldId" name="oldId" type="hidden" value="${oldId}">
		<div class="easyui-panel" title="项目年度预算<span>信息</span>" style="width:100%;" data-options="bodyCls:'panle-background',collapsible:true,headerCls:'panel-block-teal panel-description'">
			<div style="padding-top: 10px"></div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">单据编号</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="number" required="true" validType="['maxLength[100]']" width="100%" value="${model.number}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">单据名称</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="name" required="true" validType="['maxLength[100]']" width="100%" value="${model.name}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">所属组织</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="org" readonly="true" queryFieldItem="number,name" url="/systemPop/orgPage?isShowAll=true&multiSelect=false&isDcData=true"  width="100%" value="${model.org}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">项目名称</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="project" required="true" queryFieldItem="number,name,org.name" onDataChange="project_DataChange" DSTFilter="isEnable='Y'" entityPath="com.dst.slms.base.entity.MarketProjectInfo" width="100%" value="${model.project}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">年份</label>
					<div class="dst-input-block">
						<Dst:SMEnumDicBox id="year" editable="false" required="true" dicGroupCode="year" width="100%" value="${model.year}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">单据状态</label>
					<div class="dst-input-block">
						<Dst:SMEnumDicBox id="state" readonly="true" dicGroupCode="BILLSTATUS" width="100%" value="${model.state}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">销售目标</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="saleTarget" required="true" precision="2" width="100%" value="${model.saleTarget}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">费率%</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="rate" readonly="true" precision="2" width="100%" value="${model.rate}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">版本号</label>
					<div class="dst-input-block">
						<Dst:SMNumberBox id="editionnumber" width="100%" readonly="true" value="${model.editionnumber}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<div class="dst-input-block">
						<Dst:SMCheckBox id="isnew" label="是否最新版" readonly="true" value="${model.isnew}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm12">
					<label class="dst-form-label">说明</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="remake" multiline="true" height="40" validType="['maxLength[2000]']" width="100%" value="${model.remake}"/>
					</div>
				</div>
			</div>
		</div>	
		
		<div style="padding-top: 10px;height: 400px;">
			<table id="editTreeGrid" ></table> 
		</div>
		<%-- <Dst:SMEDDatagrid entityPath="com.dst.slms.plan.entity.ProjectYearBudgetE1Info" style="width:100%;height:250px;" enableCellEdit="true" rownumbers="true" 
		ctrlSelect="true" title="计划明细" data="${model.projectYearBudgetE1}" id="projectYearBudgetE1" entry_editChange="entry_change" >
			<Dst:SMEDBillToolBar id="projectYearBudgetE1tb">
				<Dst:SMDGToolBar title="新增" icon="icon-entity-addline" bindAction="addRow"/>
				<Dst:SMDGToolBar title="删除" icon="icon-entity-deleteline" bindAction="removeRow"/>
			</Dst:SMEDBillToolBar>  
			<Dst:SMEDColumnMoreHeaderGroup>
				<Dst:SMEDColumnTextBox title="id" field="id" hidden="true" width="100"/>
				<Dst:SMEDColumnBizPromptBox field="parent" hidden="true" queryFieldItem="number,name" title="父对象关联" entityPath="com.dst.slms.plan.entity.ProjectYearBudgetInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnBizPromptBox field="account" readonly="true" disPlayFormatName="number" queryFieldItem="number,name" DSTFilter="isEnable='Y'" title="科目编码" entityPath="com.dst.slms.base.entity.MarketAccountInfo"></Dst:SMEDColumnBizPromptBox>
				<Dst:SMEDColumnTextBox field="accountName" title="科目名称" readonly="true" width="100"></Dst:SMEDColumnTextBox>
				<Dst:SMEDColumnNumberBox field="amount" title="合计金额" readonly="true" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="one" title="一月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="two" title="二月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="three" title="三月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="four" title="四月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="five" title="五月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="six" title="六月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="seven" title="七月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="eight" title="八月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="nine" title="九月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="ten" title="十月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="eleven" title="十一月" precision="2"></Dst:SMEDColumnNumberBox>
				<Dst:SMEDColumnNumberBox field="twelve" title="十二月" precision="2"></Dst:SMEDColumnNumberBox>
			</Dst:SMEDColumnMoreHeaderGroup>
		</Dst:SMEDDatagrid> --%>
	</Dst:SMForm>	
</Dst:SMMain>
</div>
</body>
