package com.dst.slms.workBench.service.impl;

import com.dst.slms.base.service.IMarketProjectService;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.plan.service.sql.MarketProjectSQL;
import com.dst.slms.util.DateUtil;
import com.dst.slms.util.ParamEnum;
import com.dst.slms.workBench.service.IFeeService;
import com.dst.slms.workBench.service.sql.FeeControlSQL;
import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional
public class IFeeServiceImpl implements IFeeService {
    @Autowired
    private IMarketProjectService iMarketProjectService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final static  BigDecimal tenThousand = new BigDecimal( "10000" );
    /**
     * @description  获取营销项目组装成前台所需的下拉数据
     * @param
     * @return  R
     * @date  20/05/03 17:54
     * @author  wanghb
     * @edit
     */
    @Override
    public R getMarketProject() {
        StringBuffer SQL = new StringBuffer( MarketProjectSQL.SQL_LIST_03 );
        SQL.append( " AND FISENABLE = ? " );
        List<Map<String, Object>> list = iMarketProjectService.executeSqlQuery( SQL.toString(), ParamEnum.ISYN.YES.getCode() );
        return R.ok( ImmutableMap.of("listDate",list) );
    }

    /**
     * @description  页面数据初始化
     * @param    projectIds 项目id
     * @return  .
     * @date  20/05/04 9:23
     * @author  wanghb
     * @edit  .
     */
    @Override
    public R initData(String projectIds) {
        String condition1 = "".equals( projectIds ) ? "" : " AND l1.FprojectID in ("+projectIds+") ";
        String condition2 = " AND l1.FSTATE = ? ";
        String condition3 = "".equals( projectIds ) ? "" : " AND l1.ForgID in ( select distinct m1.ForgID from yc_cost_marketProject m1 where m1.fid in ("+projectIds+") ) ";
        String newYear = DateUtil.getSysYear();
        String audit = ParamEnum.BILLSTATUS.AUDIT.getCode();
        String yes = ParamEnum.ISYN.YES.getCode();
        String marketingSubjects = ParamEnum.MarketAccount.Market1.getName();

        Map<String, Object> returnData = new HashMap<>();
        //全盘费用预算
        StringBuffer SQL = new StringBuffer(FeeControlSQL.SQL_LIST_01);
        SQL.append( condition1 );
        SQL.append( " AND l1.FisNew = ? " );
        String budget = jdbcTemplate.queryForObject( SQL.toString(),new String[] {yes},String.class );
        //全盘已发生费用
        SQL = new StringBuffer(FeeControlSQL.SQL_LIST_02);
        SQL.append( condition1 ).append( condition2 );
        String taxConAmt = jdbcTemplate.queryForObject( SQL.toString(),new String[] {audit},String.class );

        //本年费用预算
        SQL = new StringBuffer(FeeControlSQL.SQL_LIST_03);
        SQL.append( condition1 );
        SQL.append( " AND l1.Fyear = ? " );
        SQL.append( " AND l1.FisNew = ? " );
        SQL.append( " AND l2.FaccountName = ? " );
        SQL.append( " AND l2.Fseq = 0 " );
        String yearBudget = jdbcTemplate.queryForObject( SQL.toString(),new String[] {newYear,yes,marketingSubjects},String.class );

        //本年已发生费用
        SQL = new StringBuffer(FeeControlSQL.SQL_LIST_02);
        SQL.append( condition1 );
        SQL.append( condition2 );
        SQL.append( " AND DATE_FORMAT(l1.FsignDate,'%Y') = ? " );
        String taxConAmtYear = jdbcTemplate.queryForObject( SQL.toString(),new String[] {audit,newYear},String.class );

        //年度费用与销售进度  费用进度 按项目所属组织 每个组织的已发生金额
        //本年费用预算
        SQL = new StringBuffer(FeeControlSQL.SQL_LIST_03);
        SQL.append( condition3 );
        SQL.append( " AND l1.Fyear = ? " );
        SQL.append( " AND l1.FisNew = ? " );
        SQL.append( " AND l2.FaccountName = ? " );
        SQL.append( " AND l2.Fseq = 0 " );
        BigDecimal yearBudgetTemp = UIRuleUtil.getBigDecimal(jdbcTemplate.queryForObject( SQL.toString(),new String[] {newYear,yes,marketingSubjects},String.class ));
        //年度费用与销售进度  费用进度
        SQL = new StringBuffer(FeeControlSQL.SQL_LIST_02);
        SQL.append( condition3.replace( "l1.ForgID","l1.ForgunitID" ) );
        SQL.append( condition2 );
        SQL.append( " AND DATE_FORMAT(l1.FsignDate,'%Y') = ? " );
        String taxConAmtYearTemp = jdbcTemplate.queryForObject( SQL.toString(),new String[] {audit,newYear},String.class );
        BigDecimal costProgress = BigDecimal.ZERO.compareTo( yearBudgetTemp ) == 0 ? BigDecimal.ZERO : UIRuleUtil.getBigDecimal( taxConAmtYearTemp ).divide( yearBudgetTemp,2, BigDecimal.ROUND_HALF_UP );

        //年度费用与销售进度  销售进度
        SQL = new StringBuffer(FeeControlSQL.SQL_LIST_04);
        SQL.append( condition1 );
        SQL.append( " AND l1.Fyear = ? " );
        List<Map<String, Object>> list =  jdbcTemplate.queryForList( SQL.toString(),new String[] {newYear});
        String salesProgress = list.size() > 0 ? UIRuleUtil.getString( list.get( 0 ).get( "salesProgress" ) ) : "0";

        returnData.put("budget", UIRuleUtil.getBigDecimal( budget ).divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP )  );
        returnData.put("taxConAmt", UIRuleUtil.getBigDecimal( taxConAmt ).divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP )  );
        returnData.put("yearBudget", UIRuleUtil.getBigDecimal( yearBudget ).divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP )  );
        returnData.put("taxConAmtYear", UIRuleUtil.getBigDecimal( taxConAmtYear ).divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP )  );
        returnData.put("costProgress", costProgress );
        returnData.put("salesProgress", salesProgress );
        return R.ok(ImmutableMap.of("data",returnData));
    }

    /**
     * @description  初始化Echarts
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    @Override
    public R initEcharts(String projectIds) {
        R returnData = new R();
        initEcharts1( projectIds ,returnData);
        initEcharts2( projectIds ,returnData);
        //initEcharts3( projectIds ,returnData);
        //initEcharts4( projectIds ,returnData);

        return returnData;
    }

    /**
     * @description  初始化Echarts1
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    public Map<String, Object> initEcharts1(String projectIds,R returnData) {
        String condition1 = "".equals( projectIds ) ? "" :  " AND l1.FprojectID in ("+projectIds+") ";
        String condition2 = " AND l1.FSTATE = ? ";
        String condition3 = "".equals( projectIds ) ? "" :  " AND l1.ForgID in ( select distinct m1.ForgID from yc_cost_marketProject m1 where m1.fid in ("+projectIds+") ) ";
        String newYear = DateUtil.getSysYear();
        String audit = ParamEnum.BILLSTATUS.AUDIT.getCode();
        String yes = ParamEnum.ISYN.YES.getCode();
        String marketingSubjects = ParamEnum.MarketAccount.Market1.getName();
        //本年费用预算
        StringBuffer SQL = new StringBuffer(FeeControlSQL.SQL_ECHARTS_01);
        SQL.append( condition3 );
        SQL.append( " AND l1.Fyear = ? " );
        SQL.append( " AND l1.FisNew = ? " );
        SQL.append( " AND l2.FaccountName = ? " );
        SQL.append( " AND l2.Fseq = 0 " );

        SQL.append( condition3.replace( "l1.ForgID","l3.ForgunitID" ) );
        SQL.append( condition2.replace( "l1.","l3." ) );
        SQL.append( " AND DATE_FORMAT(l3.FsignDate,'%Y') = ? " );

        SQL.append( condition3.replace( "l1.ForgID","l4.ForgID" )  );
        SQL.append( " AND l4.Fyear = ? " );
        //已发生比例 除以 预算金额
        List<Map<String, Object>> list = jdbcTemplate.queryForList( SQL.toString(),new String[] {newYear,yes,marketingSubjects,audit,newYear,newYear});
        List<Object[]> echarts1 = new ArrayList<>();
        echarts1.add( new Object[]{"公司","费用进度","销售进度"} );
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> temp = list.get(i);
            //预算费用
            BigDecimal amount = UIRuleUtil.getBigDecimal( temp.get( "amount" ) );
            Object name = temp.get( "name" );
            //已发生费用
            BigDecimal taxConAmt = UIRuleUtil.getBigDecimal( temp.get( "taxConAmt" ) );
            BigDecimal salesProgress = UIRuleUtil.getBigDecimal( temp.get( "salesProgress" ) );
            BigDecimal costProgress = BigDecimal.ZERO.compareTo( amount ) == 0 ? BigDecimal.ZERO : UIRuleUtil.getBigDecimal( taxConAmt ).divide( amount,2, BigDecimal.ROUND_HALF_UP );
            echarts1.add( new Object[]{name,costProgress,salesProgress} );
        }
        returnData.put( "echarts1",echarts1);
        return returnData;
    }

    /**
     * @description  初始化Echarts2
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    public void initEcharts2(String projectIds,R returnData) {
        String condition1 = "".equals( projectIds ) ? "" : " AND l1.FprojectID in ("+projectIds+") ";
        String condition2 = " AND l1.FSTATE = ? ";
        String condition3 = "".equals( projectIds ) ? "" : " AND l1.ForgID in ( select distinct m1.ForgID from yc_cost_marketProject m1 where m1.fid in ("+projectIds+") ) ";
        String newYear = DateUtil.getSysYear();
        String audit = ParamEnum.BILLSTATUS.AUDIT.getCode();
        String yes = ParamEnum.ISYN.YES.getCode();
        String marketingSubjects = ParamEnum.MarketAccount.Market1.getName();
        //本年已发生费用
        StringBuffer SQL = new StringBuffer(FeeControlSQL.SQL_ECHARTS_02);
        SQL.append( condition1 );
        SQL.append( condition2 );
        SQL.append( " AND DATE_FORMAT(l1.FsignDate,'%Y') = ? " );
        SQL.append( " GROUP BY l2.FID " );
        List<Map<String, Object>> list = jdbcTemplate.queryForList( SQL.toString(),new String[] {audit,newYear});
        List<Object[]> echarts2 = new ArrayList<>();
        echarts2.add( new Object[]{"公司",""} );
        List<Object> echarts3Title = new ArrayList<>();

        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> temp = list.get(i);
            Object name = temp.get( "name" );
            BigDecimal value = UIRuleUtil.getBigDecimal( temp.get( "value" ) ).divide(tenThousand, 2, BigDecimal.ROUND_HALF_UP ) ;
            Object[] taxConAmts = new Object[2];
            taxConAmts[0] = name;
            taxConAmts[1] = value;
            echarts3Title.add( name );
            echarts2.add( taxConAmts );
        }
        returnData.put( "echarts2",echarts2);
        returnData.put( "echarts3",ImmutableMap.of("title",echarts3Title,"data",list));
        returnData.put( "echarts4",echarts2);
    }

    /**
     * @description  初始化Echarts3
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    public Map<String, Object> initEcharts3(String projectIds,R returnData) {

        return returnData;
    }

    /**
     * @description  初始化Echarts4
     * @param  projectIds  所选的项目
     * @return  数据
     * @date  20/05/04 20:52
     * @author  wanghb
     * @edit  .
     */
    public Map<String, Object> initEcharts4(String projectIds,R returnData) {

        return returnData;
    }
}
