package com.dst.slms.proapproval.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.proapproval.entity.MonMarkMangeInfo;
import com.dst.slms.proapproval.service.IMonMarkMangeService;

/**   
 * 月度营销计划 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 月度营销计划
 * @author 
 * @date 2020-05-05 08:27:15
 * @version V1.0   
 *
 */
public abstract class AbstractMonMarkMangeController extends CoreBaseController {

	@Autowired
	private IMonMarkMangeService iMonMarkMangeService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/proapproval/monmarkmange/monMarkMangeList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/proapproval/monmarkmange/monMarkMangeEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iMonMarkMangeService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		MonMarkMangeInfo info = new MonMarkMangeInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("person.id");
		sic.add("person.number");
		sic.add("person.name");
		sic.add("department.id");
		sic.add("department.number");
		sic.add("department.name");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("totalAMT");
		sic.add("year");
		sic.add("month");
		sic.add("orgunit.id");
		sic.add("orgunit.number");
		sic.add("orgunit.name");
		sic.add("istolx");
		sic.add("xsmb");
		sic.add("rate");
		sic.add("monMarkMangeE1.parent.id");
		sic.add("monMarkMangeE1.parent.number");
		sic.add("monMarkMangeE1.parent.name");
		sic.add("monMarkMangeE1.theme");
		sic.add("monMarkMangeE1.themeDes");
		sic.add("monMarkMangeE1.themeAmt");
		sic.add("monMarkMangeE1.planType");
		sic.add("monMarkMangeE1.itemDes");
		sic.add("monMarkMangeE1.marketAccount.id");
		sic.add("monMarkMangeE1.marketAccount.number");
		sic.add("monMarkMangeE1.marketAccount.name");
		sic.add("monMarkMangeE1.itemStatus");
		sic.add("monMarkMangeE1.purType");
		sic.add("monMarkMangeE1.contractNature");
		sic.add("monMarkMangeE1.contact.id");
		sic.add("monMarkMangeE1.contact.number");
		sic.add("monMarkMangeE1.contact.name");
		sic.add("monMarkMangeE1.isglcontract");
		sic.add("monMarkMangeE1.supplier.id");
		sic.add("monMarkMangeE1.supplier.number");
		sic.add("monMarkMangeE1.supplier.name");
		sic.add("monMarkMangeE1.planAmt");
		sic.add("monMarkMangeE1.monAmt");
		sic.add("monMarkMangeE1.payAmt");
		sic.add("monMarkMangeE1.startNote");
		sic.add("monMarkMangeE1.remark");
		return sic;
	}

	@RequiresPermissions("Moe:MonMarkMange:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(MonMarkMangeInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("Moe:MonMarkMange:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("Moe:MonMarkMange:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("Moe:MonMarkMange:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(MonMarkMangeInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("Moe:MonMarkMange:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(MonMarkMangeInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("Moe:MonMarkMange:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(MonMarkMangeInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("Moe:MonMarkMange:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(MonMarkMangeInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("Moe:MonMarkMange:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(MonMarkMangeInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("Moe:MonMarkMange:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(MonMarkMangeInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
