package com.dst.slms.plan.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.plan.entity.CyclePaymentPlanInfo;
import com.dst.slms.plan.service.ICyclePaymentPlanService;

/**   
 * 项目全周期费用规划 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 项目全周期费用规划
 * @author 
 * @date 2020-05-04 17:39:29
 * @version V1.0   
 *
 */
public abstract class AbstractCyclePaymentPlanController extends CoreBaseController {

	@Autowired
	private ICyclePaymentPlanService iCyclePaymentPlanService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/plan/cyclepaymentplan/cyclePaymentPlanList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/plan/cyclepaymentplan/cyclePaymentPlanEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iCyclePaymentPlanService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		CyclePaymentPlanInfo info = new CyclePaymentPlanInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("saleTarget");
		sic.add("person.id");
		sic.add("person.number");
		sic.add("person.name");
		sic.add("budget");
		sic.add("rate");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("isnew");
		sic.add("editionnumber");
		sic.add("cyclePaymentPlanE1.parent.id");
		sic.add("cyclePaymentPlanE1.parent.number");
		sic.add("cyclePaymentPlanE1.parent.name");
		sic.add("cyclePaymentPlanE1.marketAccount.id");
		sic.add("cyclePaymentPlanE1.marketAccount.number");
		sic.add("cyclePaymentPlanE1.marketAccount.name");
		sic.add("cyclePaymentPlanE1.accountNumber");
		sic.add("cyclePaymentPlanE1.planAmount");
		sic.add("cyclePaymentPlanE1.rate");
		sic.add("cyclePaymentPlanE1.yfsAmount");
		sic.add("cyclePaymentPlanE1.planYe");
		sic.add("cyclePaymentPlanE1.payAmount");
		sic.add("cyclePaymentPlanE1.remarks");
		sic.add("cyclePaymentPlanE2.parent.id");
		sic.add("cyclePaymentPlanE2.parent.number");
		sic.add("cyclePaymentPlanE2.parent.name");
		sic.add("cyclePaymentPlanE2.years");
		sic.add("cyclePaymentPlanE2.planAmountRate");
		sic.add("cyclePaymentPlanE2.planAmount");
		sic.add("cyclePaymentPlanE2.yfsAmount");
		sic.add("cyclePaymentPlanE2.payAmount");
		sic.add("cyclePaymentPlanE2.year.id");
		sic.add("cyclePaymentPlanE2.year.number");
		sic.add("cyclePaymentPlanE2.year.name");
		return sic;
	}

	@RequiresPermissions("Cyn:CyclePaymentPlan:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(CyclePaymentPlanInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("Cyn:CyclePaymentPlan:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("Cyn:CyclePaymentPlan:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("Cyn:CyclePaymentPlan:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(CyclePaymentPlanInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("Cyn:CyclePaymentPlan:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(CyclePaymentPlanInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("Cyn:CyclePaymentPlan:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(CyclePaymentPlanInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("Cyn:CyclePaymentPlan:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(CyclePaymentPlanInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("Cyn:CyclePaymentPlan:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(CyclePaymentPlanInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("Cyn:CyclePaymentPlan:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(CyclePaymentPlanInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
