package com.dst.slms.plan.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.BillBaseCrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.plan.entity.AnnualPaymentPlanInfo;
import com.dst.slms.plan.service.IAnnualPaymentPlanService;

/**   
 * @Title: 年度支付计划 ServiceImpl
 * @Description: 年度支付计划
 * @author 
 * @date 2020-05-02 16:24:28
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class IAnnualPaymentPlanServiceImpl extends BillBaseCrudServiceImpl<AnnualPaymentPlanInfo> implements IAnnualPaymentPlanService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(IAnnualPaymentPlanServiceImpl.class);
	
	@Override
	protected R verifyInput(AnnualPaymentPlanInfo entity) {
		StringBuffer sb = new StringBuffer();
		sb.append(" select fid from yc_cost_annualPaymentPlan ");
		sb.append(" where fid != '"+entity.getId()+"' and fnumber != '"+entity.getNumber()+"' and Fyear = '"+entity.getYear()+"' and FmarketProjectID ='"+entity.getMarketProject().getId()+"'");
		List<Map<String,Object>> ishave = executeSqlQuery(sb.toString());
		if(ishave.size()>0){
			throw new BizException("该项目"+entity.getYear()+"年已有年度支付计划，无法新增！");
		}
		return super.verifyInput(entity);
	}
}