package com.dst.slms.contractmange.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 合同经济条款 Info 对象
 * @Description: 合同经济条款
 * @author 
 * @date 2020-05-02 17:43:18
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractSaleConEconomicsInfo  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.contractmange.entity.SaleContractInfo parent;
	
	/**日期*/
	@Column(name ="FbizDate")
	@FieldMeta(name="日期" )
	private java.util.Date bizDate;
	
	/**付款类型*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FpayTypeID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="付款类型" )
	private com.dst.slms.base.entity.PayTypeInfo payType;
	
	/**付款条件*/
	@Column(name ="Fpay")
	@FieldMeta(name="付款条件" )
	private java.lang.String pay;
	
	/**付款比例*/
	@Column(name ="FpayScale")
	@FieldMeta(name="付款比例" )
	private java.math.BigDecimal payScale;
	
	/**付款金额*/
	@Column(name ="FpayAmt")
	@FieldMeta(name="付款金额" )
	private java.math.BigDecimal payAmt;
	
	/**备注*/
	@Column(name ="Fremark")
	@FieldMeta(name="备注" )
	private java.lang.String remark;
	
	
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  父对象关联
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  父对象关联
	 */
	public void setParent(com.dst.slms.contractmange.entity.SaleContractInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  日期
	 */
	public java.util.Date getBizDate(){
		return this.bizDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  日期
	 */
	public void setBizDate(java.util.Date bizDate){
		this.bizDate = bizDate;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.PayTypeInfo
	 *@return: com.dst.slms.base.entity.PayTypeInfo  付款类型
	 */
	public com.dst.slms.base.entity.PayTypeInfo getPayType(){
		return this.payType;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.PayTypeInfo
	 *@param: com.dst.slms.base.entity.PayTypeInfo  付款类型
	 */
	public void setPayType(com.dst.slms.base.entity.PayTypeInfo payType){
		this.payType = payType;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  付款条件
	 */
	public java.lang.String getPay(){
		return this.pay;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  付款条件
	 */
	public void setPay(java.lang.String pay){
		this.pay = pay;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  付款比例
	 */
	public java.math.BigDecimal getPayScale(){
		return this.payScale;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  付款比例
	 */
	public void setPayScale(java.math.BigDecimal payScale){
		this.payScale = payScale;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  付款金额
	 */
	public java.math.BigDecimal getPayAmt(){
		return this.payAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  付款金额
	 */
	public void setPayAmt(java.math.BigDecimal payAmt){
		this.payAmt = payAmt;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  备注
	 */
	public java.lang.String getRemark(){
		return this.remark;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  备注
	 */
	public void setRemark(java.lang.String remark){
		this.remark = remark;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "7QMS0N7I";
	}
}
