package com.dst.slms.base.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.base.entity.SalesTargetInfo;
import com.dst.slms.base.service.ISalesTargetService;

/**   
 * 销售目标 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 销售目标
 * @author 
 * @date 2020-05-07 10:39:23
 * @version V1.0   
 *
 */
public abstract class AbstractSalesTargetController extends CoreBaseController {

	@Autowired
	private ISalesTargetService iSalesTargetService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/base/salestarget/salesTargetList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/base/salestarget/salesTargetEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iSalesTargetService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		SalesTargetInfo info = new SalesTargetInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("isEnable");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("yearMonth");
		sic.add("salesTarget");
		sic.add("salesAmount");
		return sic;
	}
	
	@RequiresPermissions("sat:salesTarget:list")		
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(SalesTargetInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}

	@SysPermissionName(name="列表查看")
	@RequiresPermissions("sat:salesTarget:list")	
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("sat:salesTarget:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}
	
	@SysPermissionName(name="表单查看")
	@RequiresPermissions("sat:salesTarget:view")	
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(SalesTargetInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("sat:salesTarget:edit")
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(SalesTargetInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("sat:salesTarget:save")
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(SalesTargetInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}
	
	@SysPermissionName(name="提交")
	@RequiresPermissions("sat:salesTarget:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(SalesTargetInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}
	
	@SysPermissionName(name="删除")
	@RequiresPermissions("sat:salesTarget:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(SalesTargetInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("sat:salesTarget:downExcel")
	@RequestMapping(value = "/downExcel")
	public void downExcel(SalesTargetInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
