package com.dst.slms.base.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 客户信息 Info 对象
 * @Description: 客户信息
 * @author 
 * @date 2020-05-02 11:14:42
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractCustomerInfoInfo  extends CoreBaseInfo implements java.io.Serializable {
	
	/**名称*/
	@Column(name ="FNAME")
	@FieldMeta(name="名称" )
	private java.lang.String name;
	
	/**编号*/
	@Column(name ="FNUMBER")
	@FieldMeta(name="编号" )
	private java.lang.String number;
	
	/**备注*/
	@Column(name ="FREMAKE")
	@FieldMeta(name="备注" )
	private java.lang.String remake;
	
	/**是否启用*/
	@Column(name ="FISENABLE")
	@FieldMeta(name="是否启用" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean isEnable;
	
	/**营销项目*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FprojectID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="营销项目" )
	private com.dst.slms.base.entity.MarketProjectInfo project;
	
	/**媒体信息*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmediaID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="媒体信息" )
	private com.dst.slms.base.entity.MediaInfoInfo media;
	
	
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  备注
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  备注
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否启用
	 */
	public boolean getIsEnable(){
		return this.isEnable;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否启用
	 */
	public void setIsEnable(boolean isEnable){
		this.isEnable = isEnable;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketProjectInfo
	 *@return: com.dst.slms.base.entity.MarketProjectInfo  营销项目
	 */
	public com.dst.slms.base.entity.MarketProjectInfo getProject(){
		return this.project;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketProjectInfo
	 *@param: com.dst.slms.base.entity.MarketProjectInfo  营销项目
	 */
	public void setProject(com.dst.slms.base.entity.MarketProjectInfo project){
		this.project = project;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.MediaInfoInfo
	 *@return: com.dst.slms.base.entity.MediaInfoInfo  媒体信息
	 */
	public com.dst.slms.base.entity.MediaInfoInfo getMedia(){
		return this.media;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MediaInfoInfo
	 *@param: com.dst.slms.base.entity.MediaInfoInfo  媒体信息
	 */
	public void setMedia(com.dst.slms.base.entity.MediaInfoInfo media){
		this.media = media;
	}
	
			
	@Override
	public void setBosType(String bosType) {
		this.bosType = "0NC16XAT";
	}
}
