/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.internal.brave;

import brave.Tracing;
import brave.context.log4j2.ThreadContextCurrentTraceContext;
import brave.http.HttpSampler;
import brave.http.HttpTracing;
import brave.propagation.CurrentTraceContext;
import brave.sampler.BoundarySampler;
import brave.sampler.Sampler;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import zipkin.collector.CollectorMetrics;
import zipkin.server.internal.ConditionalOnSelfTracing;
import zipkin.server.internal.brave.TracingConfiguration;
import zipkin.server.internal.brave.TracingHttpHandlerConfiguration;
import zipkin.storage.StorageComponent;
import zipkin2.Span;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.ReporterMetrics;
import zipkin2.reporter.Sender;

@Configuration
@ConditionalOnSelfTracing
@Import(value={TracingHttpHandlerConfiguration.class})
public class TracingConfiguration {
    @Bean
    Sender sender(@Lazy StorageComponent storage) {
        return new LocalSender(storage);
    }

    @Bean
    Reporter<Span> reporter(Sender sender, @Value(value="${zipkin.self-tracing.message-timeout:1}") int messageTimeout, CollectorMetrics metrics) {
        return AsyncReporter.builder((Sender)sender).messageTimeout((long)messageTimeout, TimeUnit.SECONDS).metrics((ReporterMetrics)new ReporterMetricsAdapter(metrics.forTransport("local"))).build();
    }

    @Bean
    CurrentTraceContext currentTraceContext() {
        return ThreadContextCurrentTraceContext.create();
    }

    @Bean
    Tracing tracing(@Lazy Reporter<Span> reporter, @Value(value="${zipkin.self-tracing.sample-rate:1.0}") float rate) {
        return Tracing.newBuilder().localServiceName("zipkin-server").sampler((double)rate < 0.01 ? BoundarySampler.create((float)rate) : Sampler.create((float)rate)).currentTraceContext(this.currentTraceContext()).spanReporter(reporter).build();
    }

    @Bean
    HttpTracing httpTracing(Tracing tracing) {
        return HttpTracing.newBuilder((Tracing)tracing).serverSampler((HttpSampler)new /* Unavailable Anonymous Inner Class!! */).clientSampler(HttpSampler.NEVER_SAMPLE).build();
    }
}

