/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.internal;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.undertow.server.HandlerWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.server.internal.ActuateCollectorMetrics;
import zipkin.server.internal.CorsHandler;
import zipkin.server.internal.ZipkinHealthIndicator;
import zipkin.server.internal.ZipkinHttpCollector;

@Configuration
public class ZipkinServerConfiguration
implements WebMvcConfigurer {
    @Autowired(required=false)
    @Qualifier(value="httpTracingCustomizer")
    UndertowDeploymentInfoCustomizer httpTracingCustomizer;
    @Autowired(required=false)
    @Qualifier(value="httpRequestDurationCustomizer")
    UndertowDeploymentInfoCustomizer httpRequestDurationCustomizer;
    @Autowired(required=false)
    ZipkinHttpCollector httpCollector;

    @Bean
    ZipkinHealthIndicator zipkinHealthIndicator(HealthAggregator healthAggregator) {
        return new ZipkinHealthIndicator(healthAggregator);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/info", "/actuator/info");
    }

    @Bean
    public UndertowServletWebServerFactory embeddedServletContainerFactory(@Value(value="${zipkin.query.allowed-origins:*}") String allowedOrigins) {
        UndertowServletWebServerFactory factory = new UndertowServletWebServerFactory();
        CorsHandler cors = new CorsHandler(allowedOrigins);
        if (this.httpCollector != null) {
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{info -> info.addInitialHandlerChainWrapper((HandlerWrapper)this.httpCollector)});
        }
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{info -> info.addInitialHandlerChainWrapper((HandlerWrapper)cors)});
        if (this.httpTracingCustomizer != null) {
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{this.httpTracingCustomizer});
        }
        if (this.httpRequestDurationCustomizer != null) {
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{this.httpRequestDurationCustomizer});
        }
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorSampler.class})
    CollectorSampler traceIdSampler(@Value(value="${zipkin.collector.sample-rate:1.0}") float rate) {
        return CollectorSampler.create((float)rate);
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorMetrics.class})
    CollectorMetrics metrics(MeterRegistry registry) {
        return new ActuateCollectorMetrics(registry);
    }

    @Bean
    public MeterRegistryCustomizer meterRegistryCustomizer() {
        return registry -> registry.config().meterFilter(MeterFilter.deny(id -> {
            String uri = id.getTag("uri");
            return uri != null && (uri.startsWith("/actuator") || uri.startsWith("/metrics") || uri.startsWith("/health") || uri.startsWith("/favicon.ico") || uri.startsWith("/prometheus"));
        }));
    }
}

