/*
 * Decompiled with CFR 0.152.
 */
package zipkin.server.internal;

import io.undertow.io.Receiver;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import zipkin.SpanDecoder;
import zipkin.collector.Collector;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.internal.V2JsonSpanDecoder;
import zipkin.internal.V2Proto3SpanDecoder;
import zipkin.server.internal.ZipkinHttpCollector;
import zipkin.storage.StorageComponent;

@Configuration
@ConditionalOnProperty(name={"zipkin.collector.http.enabled"}, matchIfMissing=true)
class ZipkinHttpCollector
implements HttpHandler,
HandlerWrapper {
    static final HttpString POST = HttpString.tryFromString((String)"POST");
    static final HttpString CONTENT_TYPE = HttpString.tryFromString((String)"Content-Type");
    static final HttpString CONTENT_ENCODING = HttpString.tryFromString((String)"Content-Encoding");
    final CollectorMetrics metrics;
    final Collector collector;
    final HttpCollector JSON_V2;
    final HttpCollector PROTO3;
    final HttpCollector JSON_V1;
    final HttpCollector THRIFT;
    final Receiver.ErrorCallback errorCallback;
    private HttpHandler next;
    private static final ThreadLocal<byte[]> GZIP_BUFFER = new /* Unavailable Anonymous Inner Class!! */;

    @Autowired
    ZipkinHttpCollector(StorageComponent storage, CollectorSampler sampler, CollectorMetrics metrics) {
        this.metrics = metrics.forTransport("http");
        this.collector = Collector.builder(this.getClass()).storage(storage).sampler(sampler).metrics(this.metrics).build();
        this.JSON_V2 = new HttpCollector(this, (SpanDecoder)new V2JsonSpanDecoder());
        this.PROTO3 = new HttpCollector(this, (SpanDecoder)new V2Proto3SpanDecoder());
        this.JSON_V1 = new HttpCollector(this, SpanDecoder.JSON_DECODER);
        this.THRIFT = new HttpCollector(this, SpanDecoder.THRIFT_DECODER);
        this.errorCallback = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        boolean proto;
        boolean v1;
        boolean v2 = exchange.getRelativePath().equals("/api/v2/spans");
        boolean bl = v1 = !v2 && exchange.getRelativePath().equals("/api/v1/spans");
        if (!v2 && !v1) {
            this.next.handleRequest(exchange);
            return;
        }
        if (!POST.equals(exchange.getRequestMethod())) {
            this.next.handleRequest(exchange);
            return;
        }
        String contentTypeValue = exchange.getRequestHeaders().getFirst(CONTENT_TYPE);
        boolean json = contentTypeValue == null || contentTypeValue.startsWith("application/json");
        boolean thrift = !json && contentTypeValue.startsWith("application/x-thrift");
        boolean bl2 = proto = v2 && !json && contentTypeValue.startsWith("application/x-protobuf");
        if (!(json || thrift || proto)) {
            exchange.setStatusCode(400).getResponseSender().send("unsupported content type " + contentTypeValue + "\n");
            return;
        }
        HttpCollector collector = v2 ? (json ? this.JSON_V2 : this.PROTO3) : (thrift ? this.THRIFT : this.JSON_V1);
        this.metrics.incrementMessages();
        exchange.getRequestReceiver().receiveFullBytes((Receiver.FullBytesCallback)collector, this.errorCallback);
    }

    public HttpHandler wrap(HttpHandler handler) {
        this.next = handler;
        return this;
    }

    static void error(HttpServerExchange exchange, Throwable e) {
        int code;
        String message = e.getMessage();
        int n = code = message == null || message.startsWith("Cannot store") ? 500 : 400;
        if (message == null) {
            message = e.getClass().getSimpleName();
        }
        exchange.setStatusCode(code).getResponseSender().send(message);
    }

    static byte[] gunzip(byte[] input) throws IOException {
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(input));
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(input.length);){
            int len;
            byte[] buf = (byte[])GZIP_BUFFER.get();
            while ((len = in.read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

