package com.cftech.workshop.meeting.service.impl;

import com.cftech.mp.wechat.dao.QrcodeMapper;
import com.cftech.mp.wechat.model.Qrcode;
import com.cftech.mp.wechat.service.QrcodeService;
import com.cftech.shop.qrcode.dao.WxQrcodeMapper;
import com.cftech.shop.qrcode.model.WxQrcode;
import com.cftech.workshop.meeting.model.Meeting;
import com.cftech.workshop.meeting.dao.MeetingMapper;
import com.cftech.workshop.meeting.service.MeetingService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Map;

/**
 * ServiceImpl
 *
 * @author lisw
 * @date: 2018-06-28 15:20
 */
@Service("meetingService")
public class MeetingServiceImpl extends GenericServiceImpl<Meeting> implements MeetingService {

    @Autowired
    @Qualifier("meetingMapper")
    private MeetingMapper meetingMapper;

    @Autowired
    private WxQrcodeMapper qrcodeMapper;


    @Override
    public GenericDao<Meeting> getGenericMapper() {
        return meetingMapper;
    }

    //下载二维码
    @Override
    public void addcode(WxQrcode qrcode , Meeting meeting){
            try {


                    meeting.setQrCode(qrcode.getTicket());

                meetingMapper.update(meeting);
                qrcodeMapper.save(qrcode);
            }catch (Exception e){
                e.printStackTrace();
            }
    }

    @Override
   public  Map<String,Object> fetchMeetingMobileMenu(Map<String,Object> params){
        return meetingMapper.fetchMeetingMobileMenu(params);
    }

    @Override
    public void synMobileMenu() {
        meetingMapper.synMobileMenu();
    }

}