package com.cftech.common.appitems.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 申请项
 *
 * @author faye
 * @date: 2019-08-16 10:37
 */
@Data
public class Appitems implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /* 所属单据 */

    private Long typeform;

    private String useIds;

    private Long useId;

    @ExportConfig(value = "所属用途", width = 100)
    private String useName;
    /* 是否上架 */
    @ExportConfig(value = "是否上架0:否 1:是", width = 100)
    private String isOnline;
    /* 物品名称 */
    @ExportConfig(value = "物品名称", width = 100)
    private String name;
    /* 物品规格 */
    @ExportConfig(value = "物品规格", width = 100)
    private String specifications;
    /* 真实库存 */
    @ExportConfig(value = "管理员库存", width = 100)
    private String authenticStock;
    /* 虚拟库存 */
    @ExportConfig(value = "虚拟库存", width = 100)
    private String inventedStock;
    /* 物品单价 */
    @ExportConfig(value = "物品单价", width = 100)
    private String price;
    /* 封面图 */
    @ExportConfig(value = "封面图", width = 100,showLevel = 1)
    private String cover;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;



    @ExportConfig(value = "供应商货量", width = 100)
    private Integer disStock=0;
    @ExportConfig(value = "排序值", width = 100)
    private String sort;

    public Appitems() {
        this.delFlag = false;
        this.status = "0";
    }

}
