package com.cftech.accounts.service;

import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.core.generic.GenericService;

import java.util.List;
import java.util.Map;

public interface MpAccountsService extends GenericService<MpAccountsEntity> {

	long insert(MpAccountsEntity record);

	List<MpAccountsEntity> getMpAccounts(Long userid);

	List<MpAccountsEntity> getAllAccounts(Long userid);

	List<MpAccountsEntity> getQyAccounts(Long userid);

	void updateByPrimaryKey(MpAccountsEntity mpAccounts);

	int deleteByPrimaryKey(Long id);

	MpAccountsEntity getDetail(Long id);

	List<MpAccountsEntity> getAllMpAccounts();

	List<MpAccountsEntity> getAllQpAccounts();

	MpAccountsEntity getMpAccountsAppid(String appId);
	
	int deleteByUserAccount(Map<String, Object> params);
	
	int insertUserAccounts(Map<String, Object> params);
	
	int getUserAccounts(Map<String, Object> params);

	/**
	 * 获取登陆账号对应的企业微信头像
	 * @param id
	 */
    String getByQyUserAvater(Long id);
}
