package com.cftech.accounts.service;

import java.util.List;
import com.cftech.accounts.model.SysJob;
import com.cftech.core.redis.RedisCacheConfig;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.DESUtil;
import com.cftech.core.util.SpringContextHolder;
import com.cftech.core.util.SystemConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**
 * @author KangLiang Huang
 * 启动数据库中已经设定为 启动状态(status:true)的任务 项目启动时init
 */
@Service
//@Component
@Slf4j
public class DataSourceJobThread extends Thread {

    @Autowired
    JobService jobService;
    @Autowired
    JobTask jobTask;
    @Autowired
    private RedisSubPubListener redisSubPubListener;
    @Autowired
    JedisPool jedisPool;



    @Override
    public void run() {
        try {
            boolean isCluster = Boolean.valueOf(SystemConfig.p.getProperty("quartz.isCluster"));
            if(!isCluster)
            {
                return;
            }
            Thread.sleep(5000);
            //需要添加判断
            if(SpringContextHolder.getApplicationContext()==null)
            {
                Thread.sleep(10000);
            }
            log.info("---------定时任务线程启动---------");
            Conds cond = new Conds();
            cond.equal("status","1");
            cond.equal("del_flag",0);
            List<SysJob> jobList =  jobService.fetchSearchByPage(cond,null,0,0);
            //开启任务
            try {
                jobList.forEach(jobs -> {
                            log.info("---任务[" + jobs.getJobuid()+ "]系统 init--开始启动---------");
                            jobTask.startJob(jobs);
                        }
                );
            }catch (Exception e)
            {
                log.error("自动启动，初始化开始执行任务异常",e);
            }


            if (jobList.size() == 0) {
                log.info("---数据库暂无启动的任务---------");
            } else
            {
                System.out.println("---任务启动完毕---------");
            }
            log.info("---------启动消息队-------");

            //修改问直接访问REDIS 2018-09-25 后续有问题，还原成直接获得JEDIS对象模式
//            Jedis jedis = new Jedis(SystemConfig.r.getProperty("spring.redis.host"), 6379);
//            jedis.auth(DESUtil.decrypt( SystemConfig.r.getProperty("spring.redis.password"),DESUtil.KEY));

            Jedis jedis = null;//jedisPool.getResource();
            //jedis.subscribe(redisSubPubListener,"job_listener");
            while (true)
            {
                try {
                    jedis = jedisPool.getResource();
                    jedis.auth(DESUtil.decrypt(SystemConfig.r.getProperty("spring.redis.password"),DESUtil.KEY));
                    log.info("订阅REDIS JOB");
                    jedis.subscribe(redisSubPubListener,"job_listener");
                }catch (Exception subScribeException)
                {
                    log.error("监听REDIS，定时任务失败",subScribeException);
                }finally {
                    if(jedis!=null)
                    {
                        jedis.close();
                    }
                }
            }



        } catch (Exception e) {
            log.error("初始化启动任务异常",e);
        }
    }
}
