package com.cftech.sys.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.sys.dao.LogMapper;
import com.cftech.sys.model.Log;
import com.cftech.sys.service.LogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * logService
 * Created by lisw 02/09/2016.
 */
@Service("logService")
public class LogServiceImpl extends GenericServiceImpl<Log> implements LogService {

	/**
	 * logMapper
	 */
	@Autowired
	@Qualifier("logMapper")
	private LogMapper logMapper;

	@Override
	public GenericDao<Log> getGenericMapper() {
		return logMapper;
	}

	@Override
	public List<Log> fetchSearchByPageSysUser(Conds conds, Sort sort, int page, int pageSize) {
		 Map<String, Object> params = new HashMap<String, Object>();
	     params.put("conds", conds);
	     params.put("offset", page > 0 ? page : 0);
	     params.put("limit", pageSize > 0 ? pageSize : 0);
	     params.put("sort", sort);
	     return logMapper.fetchSearchByPageSysUser(params);
	}

	@Override
	public int countSysUser(Conds conds) {
		Map<String, Object> params = new HashMap<String, Object>();
	    params.put("conds", conds);
		return logMapper.countSysUser(params);
	}
}
