package com.cftech.sys.model;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;

/**
 * mobile_log 实体类
 * 日志表
 * Created by mb 02/12/2016.
 */ 
@Data
@NoArgsConstructor
@Document(collection = "logrecords")
public class MobileLog implements Serializable {
	@Id
    private String id;
    /** 用户的openID **/
    private String openid;
    /** 记录的模块 **/
    private String module;
    /** 记录的模块名称 **/
    private String modulename;
    /** 记录的关键字 **/
    private String keyword;
    /** 记录的关键字id **/
    private String keywordid;
    /** 记录的访问时间,记录时间戳 **/
    private String vt;
    /** 记录的访问IP **/
    private String ip;
    /** 记录的Appid **/
    private String appid;
    /** 记录的页面URL **/
    private String url;
    //冗余字段
    /** field1 **/
    private String field1;   //操作日志类型  1:访问日志  2:操作日志
    /** field2 **/
    private String field2;   //省份
    /** field3 **/
    private String field3;  //城市
    /** field4 **/
    private String field4;  //昵称
    /** field5 **/
    private String field5;
    /** field6 **/
    private String field6;
    /** field7 **/
    private String field7;
    /** field8 **/
    private String field8;
    /** field9 **/
    private String field9;
    /** field10 **/
    private String field10;
}