/**
 * 
 */
package org.mp.api.wxuser.tag;

import net.sf.json.JSONObject;
import org.mp.api.core.common.WxstoreUtils;
import org.mp.api.core.exception.WexinReqException;
import org.mp.api.core.req.model.user.BatchUserTag;
import org.mp.api.core.req.model.user.Tag;
import org.mp.api.core.req.model.user.TagOperate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author lisw
 * @date 2017年1月3日下午9:06:43
 *
 */
public class JwTagAPI {
	
	private static final Logger logger = LoggerFactory.getLogger(JwTagAPI.class);
	
	/**
	 *  创建标签
	 *  一个公众号，最多可以创建100个标签
	 *  POST
	 */
	public static String  createTag = "https://api.weixin.qq.com/cgi-bin/tags/create?access_token=ACCESS_TOKEN";
	
	/**
	 * 编辑标签
	 * POST
	 */
	public static  String  editTag = "https://api.weixin.qq.com/cgi-bin/tags/update?access_token=ACCESS_TOKEN";
	
	/**
	 * 删除标签
	 * POST
	 */
	public static  String  removeTag = "https://api.weixin.qq.com/cgi-bin/tags/delete?access_token=ACCESS_TOKEN";
	
	/**
	 * 批量为用户打标签
	 * 标签功能目前支持公众号为用户打上最多三个标签。
	 * POST
	 */
	public static  String batchTagging = "https://api.weixin.qq.com/cgi-bin/tags/members/batchtagging?access_token=ACCESS_TOKEN";
	
	/**
	 * 批量为用户取消标签
	 */
	public static  String batchunTagging = "https://api.weixin.qq.com/cgi-bin/tags/members/batchuntagging?access_token=ACCESS_TOKEN";
	
	/**
	 *  创建标签
	 *  一个公众号，最多可以创建100个标签
	 *  POST
	 *  tag:标签属性    仅name有值即可
	 * @throws WexinReqException 
	 */
	public static TagOperate createTag(Tag tag,String access_token) throws WexinReqException{
		TagOperate tagOper = new TagOperate();
		tagOper.setTag(tag);
		 String createTagTemp=createTag.replace("ACCESS_TOKEN", access_token);
		JSONObject tagOperJson = JSONObject.fromObject(tagOper);
		JSONObject result = WxstoreUtils.httpRequest(createTagTemp, "POST", tagOperJson.toString());
		System.out.println(result);
		if (result.has("errcode")){//创建失败
			logger.info("创建标签失败，返回信息:"+result.toString());
		}else{  
			logger.info("创建标签成功，返回信息:"+result.toString());
		}
		tagOper=(TagOperate) JSONObject.toBean(result,TagOperate.class);
		return tagOper;
	}
	
	
	/**
	 * 编辑标签/修改标签
	 */
	public static TagOperate editTag(Tag tag,String access_token){
		TagOperate tagOperate = new TagOperate();
		tagOperate.setTag(tag);
		String editTagTemp=editTag.replace("ACCESS_TOKEN", access_token);
		JSONObject tagOperJson = JSONObject.fromObject(tagOperate);
		JSONObject result = WxstoreUtils.httpRequest(editTagTemp, "POST", tagOperJson.toString());
		System.out.println(result);
		tagOperate=(TagOperate) JSONObject.toBean(result,TagOperate.class);
		return tagOperate;
	}
	
	/**
	 * 删除标签
	 * tagid  标签ID
	 */
	public static TagOperate removeTag(Integer tagid,String access_token){
		Tag tag = new Tag();
		tag.setId(tagid);
		TagOperate tagOperate = new TagOperate();
		tagOperate.setTag(tag); 
		String removeTagTemp=removeTag.replace("ACCESS_TOKEN", access_token);
		JSONObject tagOperJson = JSONObject.fromObject(tagOperate);
		JSONObject result = WxstoreUtils.httpRequest(removeTagTemp, "POST", tagOperJson.toString());
		System.out.println(result);
		tagOperate=(TagOperate) JSONObject.toBean(result,TagOperate.class);
		return tagOperate; 
	}
	
	/**
	 * 批量为用户打标签
	 * -1	系统繁忙
	 * 40032	每次传入的openid列表个数不能超过50个
     * 45159	非法的标签
     * 40003	传入非法的openid
     * 49003	传入的openid不属于此AppID
	 */
	public static TagOperate batchTagging(BatchUserTag batchUserTag,String access_token){
		TagOperate tagOperate = new TagOperate();
		String batchTaggingTemp=batchTagging.replace("ACCESS_TOKEN", access_token);
		JSONObject tagOperJson = JSONObject.fromObject(batchUserTag);
		JSONObject result = WxstoreUtils.httpRequest(batchTaggingTemp, "POST", tagOperJson.toString());
		System.out.println(result);
		tagOperate=(TagOperate) JSONObject.toBean(result,TagOperate.class);
		return tagOperate; 
	}
	
	/**
	 * 批量为用户取消标签
	 * -1	系统繁忙
	 * 40032	每次传入的openid列表个数不能超过50个
     * 45159	非法的标签
     * 40003	传入非法的openid
     * 49003	传入的openid不属于此AppID
	 */
	public static TagOperate batchunTagging(BatchUserTag batchUserTag,String access_token){
		TagOperate tagOperate = new TagOperate();
		String batchunTaggingTemp=batchunTagging.replace("ACCESS_TOKEN", access_token);
		JSONObject tagOperJson = JSONObject.fromObject(batchUserTag);
		JSONObject result = WxstoreUtils.httpRequest(batchunTaggingTemp, "POST", tagOperJson.toString());
		System.out.println(result);
		tagOperate=(TagOperate) JSONObject.toBean(result,TagOperate.class);
		return tagOperate; 
	}
	
	
	/**
	 * 接口测试
	 * @throws WexinReqException 
	 */
	public static void main(String[] args) throws WexinReqException {
		String access_token="30KFXMDx3ZskQkvEUyW_cd9aZoyqU1DwzBaIpckBjMVBp4tgv0oVVdhwdS0TwK4BszN2IyBkhev_04bAGYiC4waakUe77hOx7PJM4L4P7PVYunXF6sU-kZPan-8I3cI9BUFiAHAQJU";
		//创建标签测试
//		Tag tag = new Tag();
//		tag.setName("黄金叶");
//		createTag(tag,access_token);
		//修改标签测试 
//		Tag tag = new Tag();
//		tag.setId(106);
//		tag.setName("钻石会员");
//		editTag(tag,access_token);
		//删除标签测试
		//removeTag(107,access_token);
		//批量为用户打标签
//		String [] openid_list = {"oW0WhwdvyPE_CJMFpnqDNq3hVeLE","oW0WhwTLTDzUWAWL-38Tr-n-k2iE"};
//		BatchUserTag batchUserTag = new BatchUserTag();
//		batchUserTag.setOpenid_list(openid_list);
//		batchUserTag.setTagid(108);
//		batchTagging(batchUserTag, access_token);
		//批量为用户取消标签
//		String [] openid_list = {"oW0WhwdvyPE_CJMFpnqDNq3hVeLE","oW0WhwTLTDzUWAWL-38Tr-n-k2iE"};
//		BatchUserTag batchUserTag = new BatchUserTag();
//		batchUserTag.setOpenid_list(openid_list);
//		batchUserTag.setTagid(108);
//		batchunTagging(batchUserTag, access_token);
	}
}
