package com.cftech.sys.model;

import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 角色模型
 * 
 **/
public class Role extends BasicEntity{
    private Long id;

    private String roleName;

    private String roleSign;

    private String description;

    
    private List<Permission> permission = new ArrayList<Permission>(); 
    
	public List<Long> getMenuIdList() {
		List<Long> menuIdList = Lists.newArrayList();
		for (Permission menu : permission) {
			menuIdList.add(menu.getId());
		}
		return menuIdList;
	}

	public void setMenuIdList(List<Long> menuIdList) {
		permission = Lists.newArrayList();
		for (Long menuId : menuIdList) {
			Permission menu = new Permission();
			menu.setId(menuId);
			permission.add(menu);
		}
	}

	public String getMenuIds() {
		return StringUtils.join(getMenuIdList(), ",");
	}
	
	
	public List<Permission> getPermission() {
		return permission;
	}

	public void setPermission(List<Permission> permission) {
		this.permission = permission;
	}

	public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName == null ? null : roleName.trim();
    }

    public String getRoleSign() {
        return roleSign;
    }

    public void setRoleSign(String roleSign) {
        this.roleSign = roleSign == null ? null : roleSign.trim();
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description == null ? null : description.trim();
    }

	@Override
	public String toString() {
		return "Role [id=" + id + ", roleName=" + roleName + ", roleSign="
				+ roleSign + ", description=" + description + ", permission="
				+ permission + "]";
	}

   

}