package com.cftech.base.org.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.sql.Timestamp;

/**
 * t_position 实体类
 * 职位表
 * Created by Neil 14/02/2017.
 */
@Data
public class Position implements Serializable {
    /**
     * 职位id
     */
    @ExportConfig(value = "职位Id", width = 100, showLevel = 1)
    private Long id;

    /**
     * 职位名称
     */
    @ExportConfig(value = "职位名称", width = 100)
    private String name; 

    /**
     * 职位编码
     */
    @ExportConfig(value = "职位编码", width = 100)
    private String number;

    /**
     * 所属的账号
     */
    private Long accountsId;

    /**
     * 上级职位Id
     */
    @ExportConfig(value = "上级职位编码", width = 100, showLevel = 2)
    private Long parentId;

    /**
     * 上级职位顺序ids
     */
    private String parentIds;

    /**
     * 状态
     */
    private String status;

    /**
     * 创建时间
     */
    @ExportConfig(value = "创建时间", width = 100, showLevel = 1,dateFormat = "yyyy-MM-dd")
    private Timestamp createTime;

    /**
     * updateTime
     */
    private Timestamp updateTime;

    /**
     * description
     */

    private String description;

    /**
     * delFlag
     */
    private boolean delFlag;

    /**
     * createBy
     */
    private Long createBy;

    /**
     * updateBy
     */
    private Long updateBy;


    public Position() {
        this.delFlag = false;
        this.status = "0";
        this.parentId = new Long(0);
    }
}