package org.mp.api.core.common.util;


import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.mp.api.wxsendmsg.model.Article;
import org.mp.api.wxsendmsg.model.ResBaseMessage;
import org.mp.api.wxsendmsg.model.ResNewsMessage;
import org.mp.api.wxsendmsg.model.ResTextMessage;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 消息工具类
 * 
 * @author lisw
 * @date 2016-8-24
 * 
 */
public class MessageUtil {

	/**
	 * 返回消息类型：文本
	 */
	public static final String RESP_MESSAGE_TYPE_TEXT = "text";

	/**
	 * 返回消息类型：音乐
	 */
	public static final String RESP_MESSAGE_TYPE_MUSIC = "music";

	/**
	 * 返回消息类型：图文
	 */
	public static final String RESP_MESSAGE_TYPE_NEWS = "news";

	/**
	 * 请求消息类型：文本
	 */
	public static final String REQ_MESSAGE_TYPE_CARD = "wxcard";


	/**
	 * 请求消息类型：卡券
	 */
	public static final String REQ_MESSAGE_TYPE_TEXT = "text";

	/**
	 * 请求消息类型：图片
	 */
	public static final String REQ_MESSAGE_TYPE_IMAGE = "image";

	/**
	 * 请求消息类型：链接
	 */
	public static final String REQ_MESSAGE_TYPE_LINK = "link";

	/**
	 * 请求消息类型：地理位置
	 */
	public static final String REQ_MESSAGE_TYPE_LOCATION = "location";

	/**
	 * 请求消息类型：音频
	 */
	public static final String REQ_MESSAGE_TYPE_VOICE = "voice";

	/**
	 * 请求消息类型：推送
	 */
	public static final String REQ_MESSAGE_TYPE_EVENT = "event";

	/**
	 * 事件类型：subscribe(订阅)
	 */
	public static final String EVENT_TYPE_SUBSCRIBE = "subscribe";

	/**
	 * 事件类型：unsubscribe(取消订阅)
	 */
	public static final String EVENT_TYPE_UNSUBSCRIBE = "unsubscribe";

	/**
	 * 事件类型：CLICK(自定义菜单点击事件)
	 */
	public static final String EVENT_TYPE_CLICK = "CLICK";
	
	/**
	 * 事件类型：Scan(二维码)
	 */
	public static final String EVENT_TYPE_SCAN = "SCAN";

	/**
	 * 多客服类型（消息转发到多客服所用）
	 */
	public static final String TRANSFER_CUSTOMER_SERVICE = "transfer_customer_service";
	
	/**
	 * 领取卡券
	 */
	public static final String EVENT_TYPE_USER_GET_CARD = "user_get_card";

	/**
	 * 转增卡券
	 */
	public static final String EVENT_TYPE_USER_GIFTING_CARD="user_gifting_card";

	/**
	 * 添加门店审核
	 */
	public static final String EVENT_TYPE_ADD_STORE_AUDIT_INFO="add_store_audit_info";

	/**
	 * 修改门店审核
	 */
	public static final String EVENT_TYPE_MODIFY_STORE_AUDIT_INFO="modify_sotre_audit_info";

	/**
	 * 核销卡券
	 */
	public static final String EVENT_TYPE_USER_CONSUME_CARD="user_consume_card";
	
	/**
	 * 事件类型
	 * */
	public static final String EVENT_TYPE_SCANCODE_PUSH = "scancode_push";

	public static final Object RESP_MESSAGE_TYPE_MPNEWS = "mpnews";

	/**
	 * 消息转发多客服对象转换成xml
	 */
	public static String customerServiceMessageToXml(ResBaseMessage resBaseMessage) {
		xstream.alias("xml", resBaseMessage.getClass());
		return xstream.toXML(resBaseMessage);
	}


	/**
	 * 解析微信发来的请求（XML）
	 * 
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static Map<String, String> parseXml(HttpServletRequest request) throws Exception {
		//将解析结果存储在HashMap中
		Map<String, String> map = new HashMap<String, String>();
		// 从request中取得输入流
		InputStream inputStream = request.getInputStream();
		System.out.println(inputStream.toString());
		// 读取输入流
		SAXReader reader = new SAXReader();
		Document document = reader.read(inputStream);
		// 得到xml根元素
		Element root = document.getRootElement();
		//得到根元素的所有子节点
		List<Element> elementList = root.elements();
		// 遍历所有子节点
		List<Element> elements;
		for (Element e : elementList){
			elements = e.elements();
			if(elements.size()>0){
				for (Element element : elements) {
					map.put(element.getName(),element.getText());
				}
			}
			map.put(e.getName(), e.getText());
		}
		// 释放资源
		inputStream.close();
		inputStream = null;
		return map;
	}
	
	@SuppressWarnings("unchecked")
	public static Map<String, String> parseXmlStr(String data) throws Exception {
		//将解析结果存储在HashMap中
		Map<String, String> map = new HashMap<String, String>();
		// 读取输入流
		Document document =DocumentHelper.parseText(data);
		// 得到xml根元素
		Element root = document.getRootElement();
		//得到根元素的所有子节点
		List<Element> elementList = root.elements();
		// 遍历所有子节点
		List<Element> elements;
		for (Element e : elementList){
			elements = e.elements();
			if(elements.size()>0){
				for (Element element : elements) {
					map.put(element.getName(),element.getText());
				}
			}
			map.put(e.getName(), e.getText());
		}
		return map;
	}
	
	/**
	 * 微信推送的xml转string，利于跳板机转发
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static String parseXmlRtnStr(HttpServletRequest request) throws Exception {
		//将解析结果存储在HashMap中
		Map<String, String> map = new HashMap<String, String>();
		// 从request中取得输入流
		InputStream inputStream = request.getInputStream();
		System.out.println(inputStream.toString());
		// 读取输入流
		SAXReader reader = new SAXReader();
		Document document = reader.read(inputStream);
		String xml = document.asXML();
		inputStream.close();
		inputStream = null;
		return xml;
	}
	
	/**
	 * 文本消息对象转换成xml
	 * 
	 * @param textMessage 文本消息对象
	 * 
	 * @return xml
	 */
	public static String textMessageToXml(ResTextMessage textMessage) {
		xstream.alias("xml", textMessage.getClass());
		return xstream.toXML(textMessage);
	}


	/**
	 * 图文消息对象转换成xml
	 * 
	 * @param newsMessage 图文消息对象
	 * @return xml
	 */
	public static String newsMessageToXml(ResNewsMessage newsMessage) {
		xstream.alias("xml", newsMessage.getClass());
		xstream.alias("item", new Article().getClass());
		return xstream.toXML(newsMessage);
	}
	protected static String PREFIX_CDATA = "<![CDATA[";
	protected static String SUFFIX_CDATA = "]]>";
	/**
	 * 扩展xstream，使其支持CDATA块
	 * 初始化XStream 可支持某一字段可以加入CDATA标签 如果需要某一字段使用原文
	 * 就需要在String类型的text的头加上"<![CDATA["和结尾处加上"]]>"标签， 以供XStream输出时进行识别
	 * @date 
	 */
	private static XStream xstream = new XStream(new XppDriver() {
		public HierarchicalStreamWriter createWriter(Writer out) {
			return new PrettyPrintWriter(out) {
				// 对所有xml节点的转换都增加CDATA标记
				boolean cdata = true;
				@SuppressWarnings("unchecked")
				public void startNode(String name, Class clazz) {
					super.startNode(name, clazz);
				}

				protected void writeText(QuickWriter writer, String text) {
					if (cdata) {
						writer.write(PREFIX_CDATA);
						writer.write(text);
						writer.write(SUFFIX_CDATA);
					} else {
						writer.write(text);
					}
				}
			};
		}
	});
}
