package com.cftech.mp.wechat.service.impl;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.mp.wechat.dao.ImagetextMapper;
import com.cftech.mp.wechat.model.Imagetext;
import com.cftech.mp.wechat.service.ImagetextService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * imagetextService
 * Created by lisw 25/10/2016.
 */
@Service("imagetextService")
public class ImagetextServiceImpl extends GenericServiceImpl<Imagetext> implements ImagetextService {

	/**
	 * imagetextMapper
	 */
	@Autowired
	@Qualifier("imagetextMapper")
	private ImagetextMapper imagetextMapper;

	@Override
	public GenericDao<Imagetext> getGenericMapper() {
		return imagetextMapper;
	}

	@Override
	public List<Imagetext> fetchSearchByInPage(Conds conds,String ids) {
		 Map<String, Object> params = new HashMap<String, Object>();
	     params.put("conds", conds);
	     params.put("ids",ids);
	     return imagetextMapper.fetchSearchByInPage(params);
	}
}
