package com.cftech.order.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.order.model.*;
import com.cftech.order.dao.OrderMapper;
import com.cftech.order.service.OrderService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 订单管理ServiceImpl
*
* @author Licc
* @date: 2020-10-10 14:20
*/
@Service("orderService")
public class OrderServiceImpl extends GenericServiceImpl<Order> implements OrderService {

    @Autowired
    @Qualifier("orderMapper")
    private OrderMapper orderMapper;

    @Override
    public GenericDao<Order> getGenericMapper() {
        return orderMapper;
    }

    @Override
    public List<Order> fetchSearchBy(Conds conds, Sort sort, int page, int pageSize, Long id) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        params.put("id", id);
        return orderMapper.fetchSearchByPage(params);
    }

    @Override
    public List<ProductOrder> listProduct() {
        return orderMapper.listProduct();
    }

    @Override
    public OrderFromVO fetchId(Serializable id) {
        return orderMapper.fetchId(id);
    }

    @Override
    public List<OrderFromVO> fetchProductId(Serializable id) {
        return orderMapper.fetchProductId(id);
    }

    @Transactional
    @Override
    public Long newlyAdded(String datas, Long accountsId) {
        OrderDetail orderDetail = null;
        Map<String, Object> params =  new HashMap<String, Object>();;
        datas = datas.replaceAll("&quot;","\"");
        JSONArray jsonArray = JSONArray.fromObject(datas);
        if (jsonArray.size()>0){
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                long id = jsonObject.getLong("id");
                long productId = jsonObject.getLong("productId");
                long drugsNum = jsonObject.getLong("drugsNum");
                double price = jsonObject.getDouble("price");
                double amount = jsonObject.getDouble("amount");
                double orderAmount = jsonObject.getDouble("orderAmount");
                params.put("id",id);
                params.put("accountsId",accountsId);
                params.put("productId",productId);
                params.put("drugsNum",drugsNum);
                params.put("price",price);
                params.put("amount",amount);
                Integer fetcheDeta = orderMapper.fetcheDeta(params);
                if (fetcheDeta>0 || fetcheDeta!=null){
                    orderMapper.updateDetill(params);
                }else {
                    ProductDto productDtos = orderMapper.fetchProduct(params);
                    orderDetail = new OrderDetail();
                    Order orders = orderMapper.fetchOrder(id);
                    orderDetail.setOrderId(id);
                    orderDetail.setOrderCode(orders.getOrderCode());
                    orderDetail.setDrugsId(productDtos.getId());
                    orderDetail.setDrugsNum(drugsNum);
                    orderDetail.setOpenid(orders.getOpenid());
                    orderDetail.setPrice(productDtos.getPrice());
                    orderDetail.setAmount(amount);
                    orderDetail.setDrugsCode(productDtos.getProductNumber());
                    orderDetail.setDrugsSku(productDtos.getFormat());
                    orderDetail.setAccountsId(accountsId);
                    Integer detill = orderMapper.saveDetill(orderDetail);
                    if (detill>0){
                        orderMapper.updateOrder(params);
                    }

                }
            }
        }

//        Long detill = orderMapper.updateDetill(id, productId, drugsNum, price, amount, accountsId);
//        List<ProductDto> productDtos = orderMapper.fetchProduct(productId, accountsId);
//        List<Order> orders = orderMapper.fetchOrder(id);
//        orderDetail.setOrderId(id);

        return null;

    }

}