package com.cftech.activity.log.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.activity.log.model.ScracthLog;
import com.cftech.activity.log.model.ScracthLogDto;
import com.cftech.activity.log.service.ScracthLogService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 刮刮卡活动记录表Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String SCRACTHLOG_VIEW = "qy:scracthLog:view"
 * 查看:public static final String SCRACTHLOG_EDIT = "qy:scracthLog:edit"
 *
 * @author lisw
 * @date: 2017-04-27 14:05
 */
@Slf4j
@Controller
@RequestMapping("/a/scracthLog")
public class ScracthLogController {

    public static final String SCRACTHLOG_VIEW = "qy:scracthLog:view";
    public static final String SCRACTHLOG_EDIT = "qy:scracthLog:edit";

    @Autowired
    private ScracthLogService scracthLogService;


    //列表页面
    @RequiresPermissions(value = SCRACTHLOG_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET, RequestMethod.POST})
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "scracthLog/scracthLoglist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = SCRACTHLOG_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.GET,RequestMethod.POST})
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            ScracthLog scracthLog = scracthLogService.fetchById(id);
            model.addAttribute("data", scracthLog);
        }
        return "scracthLog/scracthLogform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = SCRACTHLOG_EDIT)
    @RequestMapping(value = "/formData",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject formData(ScracthLog scracthLog, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (scracthLog != null && scracthLog.getId() != null) {
                scracthLog.setUpdateBy(UserUtils.getUser().getId());
                scracthLogService.update(scracthLog);
                rtnJson.put("errorNo", 0);
            } else {
                scracthLog.setAccountsId(accountsId);
                scracthLog.setDelFlag(false);
                scracthLog.setAccountsId(UserUtils.getmpaccounts(request));
                scracthLog.setCreateBy(UserUtils.getUser().getId());
                scracthLog.setUpdateBy(UserUtils.getUser().getId());
                scracthLogService.save(scracthLog);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = SCRACTHLOG_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, ScracthLogDto scracthLogDto, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("s.del_flag", Constants.DEL_FLAG_0);
        conds.equal("sl.accounts_id", accountsId);
        if (!StringUtils.isEmpty(scracthLogDto.getTitle())) {
            conds.like("sl.title", scracthLogDto.getTitle());
        }
        if (!StringUtils.isEmpty(scracthLogDto.getName())) {
            conds.like("m.name",scracthLogDto.getName());
        }


        Sort sort = new Sort("sl.create_time", OrderType.DESC);
        List<ScracthLogDto> list = scracthLogService.fetchSearchByPageDto(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = scracthLogService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = SCRACTHLOG_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            scracthLogService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    @RequiresPermissions(value = SCRACTHLOG_EDIT)
    @RequestMapping(value = "/exportExcel",method = RequestMethod.GET)
    public void exportExcel(HttpServletRequest request, HttpServletResponse response, ScracthLogDto scracthLogDto){
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("s.del_flag", Constants.DEL_FLAG_0);
        conds.equal("sl.accounts_id", accountsId);
        if (!StringUtils.isEmpty(scracthLogDto.getTitle())) {
            conds.like("sl.title", scracthLogDto.getTitle());
        }
        if (!StringUtils.isEmpty(scracthLogDto.getName())) {
            conds.like("m.name",scracthLogDto.getName());
        }


        Sort sort = new Sort("sl.create_time", OrderType.DESC);

        List<ScracthLogDto> list = scracthLogService.fetchSearchByPageDto(conds, sort, 0, 0);
//        if(list!=null && list.size()>0){
//            for (WheelLogDto wheelLogDto1 : list){
//                if(wheelLogDto1.getCreate_time()!=null)
//                    wheelLogDto1.setCreate_time_str(DateFormatUtils.getDateFormat(wheelLogDto1.getCreate_time(),"yyyy-MM-dd HH:mm" ));
//            }
//        }
        // 生成Excel并使用浏览器下载
        ExcelKit.$Export(ScracthLogDto.class, response).toExcel(list, "刮刮卡参与人员信息");
    }

}
