var myActivity = (function () {
  'use strict';
  var MyActivity = function (params) {
    var p = this;
    p.params = {
      appid: '',
      accountsId: '',
      cfApp: null,
      devMode: false,
      dataApi: G.baseUri() + '/mobile/auth/member/getmymeeting',
      vt: ''
    };

    for (var param in params) {
      p.params[param] = params[param];
    }
    var cfApp = p.params.cfApp;

    if (p.params.devMode) {
      p.params.dataApi = 'json/my-activity.json';
    }
    p.page = 0;
    p.loading = false;
    p.type = 0;
p.english = cfApp.getQueryString('english') == 1 ? true : false;
    console.log(p.english);

    /**
     * 判断app字段
     * @returns 是否app有值
     */
    var validAppField = function () {
      if (!p.params.appid || p.params.appid == '') {
        return false;
      } else {
        return true;
      }
    };

    /**
     * 确认初始化的app 和tokenId 两个值是否都存在
     * 如果不存在则获取一次,获取不到则初始化失败
     * @returns 初始化基础字段是否成功
     */
    var initBaseFields = function () {
      if (!validAppField()) {
        p.params.appid = cfApp.getQueryString('appid');
        //p.params.accountsId = cfApp.getQueryString('accountsId');
      }



      //如果获取不到app和tokenId,则直接从传入的CfApp中获取值
      if (!validAppField()) {
        if (p.params.cfApp) {
          p.params.appid = cfApp.getAppId();
          //p.params.tokenId = cfApp.getTokenId();
        }
      }
      p.empInfo = cfApp.getMpInfo();
      p.params.accountsId = p.empInfo.accountsId;
      return validAppField();
    };

    /**
     * 初始化组件
     * @returns {boolean}
     */


    p.init = function () {



      if (initBaseFields()) {

        log();
        loadData();
        tabEvent();
        //initInfinite();
        event();
 $('.language').click(function () {
   if(!p.english){
location.href = 'my-activity-english.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id') + '&english=1';
   }else{
location.href = 'my-activity.html?appid=' + p.params.appid + '&id=' + cfApp.getQueryString('id');
   }
          
        });
        return true;
      } else {
        return false;
      }
    };
    var log = function () {
      var formdata = {
        openid: p.empInfo.openId,
        module: "个人中心",
        modulename: "我的活动",
        keyword: "我的活动",
        keywordid: '',
        vt: new Date().getTime(),
        appid: cfApp.getQueryString('appid'),
        url: location.href
      };
      G.ajax(G.devModePost, '/schaeffler/mobile/testAsync/doLOg', formdata, function (retdata) {


      });
    }

    var loadData = function () {
      $.showLoading();
      var formdata = {
        member_uid: p.empInfo.memberId,
        type: p.type
      };
      G.ajax('get', p.params.dataApi, formdata, function (retdata) {
        $.hideLoading();
        if (retdata.errorNo == '0') {

          var content = $('#list-template').html();
          p.template = Handlebars.compile(content);
          var htmlStr = p.template(retdata);
          $('#list').append(htmlStr);

          if (p.type == 0) {
            $('.end-label').hide();
          } else {
            $('.end-label').show();
          }
          // if (retdata.data.length < 10) {
          //   $('.weui-loadmore').remove();
          //   p.loading = true;
          // } else {
          //   p.pageNo++;
          //   p.loading = false;
          // }

        }

      });


    }
    var tabEvent = function () {
      $('.tab li').click(function () {
        var obj = $(this);
        if (obj.hasClass('tab1')) {
          $('.tab2').removeClass('choose');
          $('.tab2').find('img').attr('src', 'image/tab2.png');
          $('.tab1').addClass('choose');
          $('.tab1').find('img').attr('src', 'image/tab1-choose.png');
          p.type = 0;
        } else {
          $('.tab1').removeClass('choose');
          $('.tab1').find('img').attr('src', 'image/tab1.png');
          $('.tab2').addClass('choose');
          $('.tab2').find('img').attr('src', 'image/tab2-choose.png');
          p.type = 1;
        }
        $('#list').html('');
        loadData();
      })
    }
    var initInfinite = function () {
      $('body').infinite().on("infinite", function () {
        if (p.loading) return;
        p.loading = true;

        setTimeout(function () {

          loadData();

        }, 800);
      });
    };

    var event = function () {
      $('#list').on('click', 'li', function () {
        var id = $(this).attr('id');

        if(p.english){
location.href = 'meeting-intro-english.html?appid=' + p.params.appid + '&id=' + id+'&english=1';
        }else{
location.href = 'meeting-intro.html?appid=' + p.params.appid + '&id=' + id;
        }
        
      })
    }


  };

  return MyActivity;
})();