package com.cftech.workshop.detail_log.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.base.codingrule.utils.CodingruleUtils;
import com.cftech.workshop.detail_log.model.Detail_log;
import com.cftech.workshop.detail_log.service.Detail_logService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.HtmlUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;


/**
 * Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String DETAIL_LOG_VIEW = "qy:detail_log:view"
 * 查看:public static final String DETAIL_LOG_EDIT = "qy:detail_log:edit"
 *
 * @author byj
 * @date: 2018-08-27 13:38
 */
@Slf4j
@Controller
@RequestMapping("/a/detail_log")
public class Detail_logController {

    public static final String DETAIL_LOG_VIEW = "qy:detail_log:view";
    public static final String DETAIL_LOG_EDIT = "qy:detail_log:edit";

    @Autowired
    private Detail_logService detail_logService;
    @Autowired
    private CodingruleUtils codingruleUtils;


    //列表页面
    @RequiresPermissions(value = DETAIL_LOG_VIEW)
    @RequestMapping("/list")
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "detail_log/detail_loglist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = DETAIL_LOG_VIEW)
    @RequestMapping("/form")
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Detail_log detail_log = detail_logService.fetchById(id);
            model.addAttribute("data", detail_log);
        }
        return "detail_log/detail_logform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = DETAIL_LOG_EDIT)
    @RequestMapping("/formData")
    @ResponseBody
    public JSONObject formData(Detail_log detail_log, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (detail_log != null && detail_log.getId() != null) {
                detail_log.setUpdateBy(UserUtils.getUser().getId());
                detail_logService.update(detail_log);
                rtnJson.put("errorNo", 0);
            } else {
                detail_log.setNumber(codingruleUtils.getNumber(accountsId, Detail_log.class.getName()));
                detail_log.setAccountsId(accountsId);
                detail_log.setDelFlag(false);
                detail_log.setAccountsId(UserUtils.getmpaccounts(request));
                detail_log.setCreateBy(UserUtils.getUser().getId());
                detail_log.setUpdateBy(UserUtils.getUser().getId());
                detail_logService.save(detail_log);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = DETAIL_LOG_VIEW)
    @RequestMapping(value = "/listData")
    public String listData( Detail_log detail_log, HttpServletRequest request,Model model) {
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        if(!StringUtils.isEmpty(detail_log.getMemberUid())){
            conds.equal("memberUid",detail_log.getMemberUid());
        }
        if(!StringUtils.isEmpty(detail_log.getMeetingId())){
            conds.equal("meeting_id",detail_log.getMeetingId());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Detail_log> list = detail_logService.fetchSearchByPage(conds, sort, 0, 0);
        JSONArray jsonArray = new JSONArray();
        for(Detail_log d:list){
            d.setDetaillog(HtmlUtils.htmlUnescape(d.getDetaillog()));
            jsonArray.add(d);
        }
        model.addAttribute("list",jsonArray);
        model.addAttribute("meetingId",detail_log.getMeetingId());
        return "detail_log/detail_loglist";
    }

    //删除数据
    @RequiresPermissions(value = DETAIL_LOG_EDIT)
    @RequestMapping("/delete")
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            detail_logService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
