package com.cftech.sys.security;

import com.cftech.sys.dao.UserMapper;
import com.cftech.sys.model.User;
import com.cftech.sys.service.impl.SpringContextHolderImp;
import com.google.common.collect.Maps;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.subject.Subject;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * 用户工具类
 * @author lisw
 * @version 2016-8-24
 */
public class UserUtils  {

	private static UserMapper userDao = SpringContextHolderImp.getBean(UserMapper.class);
	public static final String CACHE_USER = "user";
	
	public static Long getmpaccounts(HttpServletRequest request)
	{
		Object obj = request.getSession().getAttribute("mpaccounts");
		if(obj==null)
		{
			return null;
		}else
		{
			return (Long)obj;
		}
	}

	public static boolean isAdmin(){
		if(getUser().getId()==1 || getUser().getId()==0 ){
			return true;
		}
		return false;
	}


	
	public static Long getSession(HttpServletRequest request){
		Object obj  = request.getSession().getAttribute("memberid");
		if(obj==null){
			return null;
		}else{
			return (Long)obj;
		}
	}


	public static User getUser(){
		User user = (User)getCache(CACHE_USER);
		if (user == null){
			try{
				Subject subject = SecurityUtils.getSubject();
				SecurityRealm.Principal principal =(SecurityRealm.Principal) subject.getPrincipal();
				if (principal!=null){
					user = userDao.fetchById(principal.getId());
					putCache(CACHE_USER, user);
				}
			}catch (UnavailableSecurityManagerException e) {

			}catch (InvalidSessionException e){

			}
		}
		if (user == null){
			user = new User();
			try{
				SecurityUtils.getSubject().logout();
			}catch (UnavailableSecurityManagerException e) {

			}catch (InvalidSessionException e){

			}
		}
		return user;
	}
	
	public static User getUser(boolean isRefresh){
		if (isRefresh){
			removeCache(CACHE_USER);
		}
		return getUser();
	}


	
	// ============== User Cache ==============
	
	public static Object getCache(String key) {
		return getCache(key, null);
	}
	
	public static Object getCache(String key, Object defaultValue) {
		Object obj = getCacheMap().get(key);
		return obj==null?defaultValue:obj;
	}

	public static void putCache(String key, Object value) {
		getCacheMap().put(key, value);
	}

	public static void removeCache(String key) {
		getCacheMap().remove(key);
	}
	
	public static Map<String, Object> getCacheMap(){
		Map<String, Object> map = Maps.newHashMap();
		try{
			Subject subject = SecurityUtils.getSubject();
			SecurityRealm.Principal principal = (SecurityRealm.Principal)subject.getPrincipal();
			return principal!=null?principal.getCacheMap():map;
		}catch (UnavailableSecurityManagerException e) {
			
		}catch (InvalidSessionException e){
			
		}
		return map;
	}


	//获取用户所属门店
	public static User getStoreUser(){
		User user = (User)getCache(CACHE_USER);
		user = userDao.fetchStoreUserById(user.getId());
		putCache(CACHE_USER, user);
		return user;
	}

}
