package com.cftech.mp.area.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.mp.area.model.Area;
import com.cftech.mp.area.service.AreaService;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.security.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/** 
 * @author 作者 lisw: 
 * @version 创建时间：2016年9月21日 下午2:13:01 
 * 类说明 
 */
@Controller
@RequestMapping("/a/area")
public class AreaController {
	
	@Autowired
	private AreaService areaService;
	
	@RequestMapping("list")
	@RequiresPermissions(value=PermissionSign.AREA_VIEWS)
	public String list(){
		return "/managerarea/arealist";
	}

	/**
	 *
	 */
	@RequestMapping(value = "/areaChildsId",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public JSONObject areaChildsId(Long id,int type){
		JSONObject rtnJson = new JSONObject();
		try{
			Conds conds = new Conds();
			conds.equal("citytype",type);
			conds.equal("delflag",0);
			conds.equal("affiliationareaid",id);
			Sort sort = new Sort("sort", OrderType.ASC);
			List<Area> areaList = areaService.fetchSearchByPage(conds, sort, 0,0);
			rtnJson.put("errorNo",0);
			rtnJson.put("data", areaList);
		}catch (Exception e){
			rtnJson.put("errorNo",1);
			e.printStackTrace();
		}
		return rtnJson;
	}

	/**
	 * 三级菜单
	 * @return
	 */
	@RequestMapping(value = "fetchData",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public JSONObject getfetchData(String ids){
	List<String> arrList = new ArrayList<>();
		if(StringUtils.isNotBlank(ids)){
			String [] idsArr = ids.split(",");
			arrList= Arrays.asList(idsArr);
		}
		JSONObject rtnJson = new JSONObject();
		JSONArray array = new JSONArray();
		Sort sort = new Sort("affiliationareaid", OrderType.ASC);
		Conds conds = new Conds();
		conds.lessThan("citytype","3");
		conds.equal("delflag",0);
		List<Area> areaList = areaService.fetchSearchByPage(conds, sort, 0,0);
		
		Conds childConds = new Conds();
		childConds.equal("citytype","3");
		childConds.equal("delflag",0);
		List<Area> childsList = areaService.fetchSearchByPage(childConds, sort, 0,0);
		JSONObject t = new JSONObject();
		t.put("id", 0);
		t.put("pId", -1);
		t.put("name", "地区");
		t.put("open",true); 
		array.add(t);
		for(Area area : areaList){
			JSONObject tmp = new JSONObject();
			tmp.put("id",area.getAreaid());
			tmp.put("pId",area.getAffiliationareaid());
			tmp.put("name",area.getAreaname());
			if(arrList.contains(area.getAreaid().toString())){
				tmp.put("checked",true);
			}
			array.add(tmp);
			if(area.getCitytype()==2){
				for(Area aea : childsList){
					if(aea.getAffiliationareaid().equals(area.getAreaid())){
						JSONObject cTmp = new JSONObject();
						cTmp.put("id",aea.getAreaid());
						cTmp.put("pId",aea.getAffiliationareaid());
						cTmp.put("name",aea.getAreaname());
						if(arrList.contains(aea.getAreaid().toString())){
							cTmp.put("checked",true);
						}
						array.add(cTmp);
					}
				}
			}
			
			
		}
		rtnJson.put("aaData", array);
		return rtnJson;
	}


	/**
	 * 四级菜单
	 * @return
	 */
	@RequestMapping(value = "fetchDataC",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public JSONObject getfetchDataC(){
		JSONObject rtnJson = new JSONObject();
		JSONArray array = new JSONArray();
		Sort sort = new Sort("sort", OrderType.ASC);
		Conds conds = new Conds();
		conds.lessThan("citytype","5");
		conds.equal("delflag",0);
		List<Area> areaList = areaService.fetchSearchByPage(conds, sort, 0,0);


		JSONObject t = new JSONObject();
		t.put("id", 0);
		t.put("pId", -1);
		t.put("name", "地区管理");
		t.put("open",true);
		array.add(t);
		for(Area area : areaList){
			JSONObject tmp = new JSONObject();
			tmp.put("id",area.getAreaid());
			tmp.put("pId",area.getAffiliationareaid());
			tmp.put("name",area.getAreaname());

			array.add(tmp);
		}
		rtnJson.put("aaData", array);
		return rtnJson;
	}





	/**
	 * 二级菜单
	 * @return
	 */
	@RequestMapping(value = "getfetchDataChild",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public JSONObject getfetchDataChild(String ids){

		List<String> arrList = new ArrayList<>();
		if(StringUtils.isNotBlank(ids)){
			String [] idsArr = ids.split(",");
			arrList= Arrays.asList(idsArr);
		}
		JSONObject rtnJson = new JSONObject();
		JSONArray array = new JSONArray();
		Sort sort = new Sort("affiliationareaid", OrderType.ASC);
		Conds conds = new Conds();
		conds.lessThan("citytype","3");
		conds.equal("delflag",0);
		List<Area> areaList = areaService.fetchSearchByPage(conds, sort, 0,0);


		JSONObject t = new JSONObject();
		t.put("id", 0);
		t.put("pId", -1);
		t.put("name", "地区管理");
		//t.put("open",true);
		//array.add(t);
		for(Area area : areaList){
			JSONObject tmp = new JSONObject();
			if(arrList.contains(area.getAreaid().toString())){
				tmp.put("checked",true);
			}
			tmp.put("id",area.getAreaid());
			tmp.put("pId",area.getAffiliationareaid());
			tmp.put("name",area.getAreaname());
			array.add(tmp);
		}
		rtnJson.put("aaData", array);
		return rtnJson;
	}
	
	@RequestMapping(value = "fetchChilds",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public JSONObject getfetchChilds(Integer affiliationareaid){
		JSONObject rtnJson = new JSONObject();
		JSONArray array = new JSONArray();
		Sort sort = new Sort("affiliationareaid", OrderType.ASC);
		Conds conds = new Conds();
		conds.equal("affiliationareaid",affiliationareaid);
		conds.equal("delflag",0);
		List<Area> areaList = areaService.fetchSearchByPage(conds, sort, 0,0);
		JSONObject t = new JSONObject();
		t.put("id", 0);
		t.put("pId", -1);
		t.put("name", "地区管理");
		t.put("open",true); 
		array.add(t);
		for(Area area : areaList){
			JSONObject tmp = new JSONObject();
			tmp.put("id",area.getAreaid());
			tmp.put("pId",area.getAffiliationareaid());
			tmp.put("name",area.getAreaname());
			array.add(tmp);
		}
		rtnJson.put("aaData", array);
		return rtnJson;
	}
	
	@RequestMapping(value = "save",method = RequestMethod.POST)
	@RequiresPermissions(value=PermissionSign.AREA_EDIT)
	@ResponseBody
	public JSONObject save(Long  parentId){
		JSONObject rtnJson = new JSONObject();
		Sort sort = new Sort("areaid",OrderType.DESC);
		Conds conds = new Conds();
		conds.equal("areaid",parentId);
		Area a = areaService.fetchSearchByConds(conds);
		try {
			if(parentId!=null){
				Area area = new Area();
				List<Area> areaList = areaService.fetchSearchByPage(null, sort,0,1);
				area.setAreaid(areaList.get(0).getAreaid()+1);
				area.setAffiliationareaid(parentId.intValue());
				area.setDelflag('0');
				area.setCitytype((byte)(Integer.valueOf(a.getCitytype())+1));
				area.setCreateby(UserUtils.getUser().getId());
				area.setUpdateby(UserUtils.getUser().getId());
				areaService.saveCache(area);
				rtnJson.put("errorNo",0);
				rtnJson.put("aaData", JSONObject.toJSON(area));
			}
		} catch (Exception e) {
			rtnJson.put("errorNo",1);
		}
		;
		return rtnJson;
	}
	
	@RequestMapping(value = "remove",method = RequestMethod.POST)
	@RequiresPermissions(value=PermissionSign.AREA_EDIT)
	@ResponseBody
	public JSONObject remove(Long id){
		JSONObject rtnJson = new JSONObject();
		Conds conds = new Conds();
		conds.equal("delflag","0");
		conds.equal("areaid", id);
		Area city = areaService.fetchSearchByConds(conds);
		try {
			if(city!=null){
				city.setDelflag('1');
				areaService.updateCache(city);
				rtnJson.put("errorNo",0);
			}
		} catch (Exception e) {
			rtnJson.put("errorNo",1);
		}
		return rtnJson;
	}
	
	@RequestMapping(value = "update",method = RequestMethod.POST)
	@RequiresPermissions(value=PermissionSign.AREA_EDIT)
	@ResponseBody
	public JSONObject update(Area area){
		JSONObject rtnJson = new JSONObject();
		try {
			if(area!=null){
				area.setUpdateby(UserUtils.getUser().getId());
				areaService.updateCache(area);
				rtnJson.put("errorNo",0);
			}
		} catch (Exception e) {
			rtnJson.put("errorNo",1);
		}
		return rtnJson;
	}
	
	@RequestMapping(value = "getAreaDetail",method = {RequestMethod.GET,RequestMethod.POST})
	@ResponseBody
	public JSONObject getAreaDetail(Long id){
		JSONObject rtnJson = new JSONObject();
		try {
			if(id!=null){
				Conds conds = new Conds();
				conds.equal("areaid", id);
				conds.equal("delflag",0);
				Area area = areaService.fetchSearchByConds(conds);
				rtnJson.put("aaData", JSONObject.toJSON(area));
				rtnJson.put("errorNo",0);
			}
		} catch (Exception e) {
			rtnJson.put("errorNo",1);
		}
		return rtnJson;
	}
}
 