package com.cftech.review.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.review.model.Review;
import com.cftech.review.service.ReviewService;
import com.cftech.review.vo.ReviewDto;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * 评论Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String REVIEW_VIEW = "qy:review:view"
 * 查看:public static final String REVIEW_EDIT = "qy:review:edit"
 *
 * @author lisw
 * @date: 2017-05-11 10:31
 */
@Slf4j
@Controller
@RequestMapping("/a/review")
public class ReviewController {

    public static final String REVIEW_VIEW = "qy:review:view";
    public static final String REVIEW_EDIT = "qy:review:edit";

    @Autowired
    private ReviewService reviewService;


    //列表页面
    @RequiresPermissions(value = REVIEW_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET,RequestMethod.POST})
    public String list(HttpServletRequest request, Model model,Long entityId , Long id , String moduleType) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        model.addAttribute("entityId",entityId);
        model.addAttribute("id",id);
        model.addAttribute("moduleType",moduleType);
        return "review/reviewlist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = REVIEW_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.GET,RequestMethod.POST})
    public String form(HttpServletRequest request, String id, Model model ) {
        if (!StringUtils.isEmpty(id)) {
            Review review = reviewService.fetchById(id);
            model.addAttribute("data", review);
        }
        return "review/reviewform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = REVIEW_EDIT)
    @RequestMapping(value = "/formData",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject formData(Review review, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (review != null && review.getId() != null) {
                review.setUpdateBy(UserUtils.getUser().getId());
                reviewService.update(review);
                rtnJson.put("errorNo", 0);
            } else {
                review.setAccountsId(accountsId);
                review.setDelFlag(false);
                review.setAccountsId(UserUtils.getmpaccounts(request));
                review.setCreateBy(UserUtils.getUser().getId());
                review.setUpdateBy(UserUtils.getUser().getId());
                review.setLikes("1");
                review.setFabulous(Long.valueOf(0));
                reviewService.save(review);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            log.error("保存展会失败",e);
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = REVIEW_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Review review, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("review.del_flag", Constants.DEL_FLAG_0);
        conds.equal("review.accounts_id", accountsId);
        conds.equal("fans.delflag","0");
        if (!StringUtils.isEmpty(review.getModule_type())) {
            conds.equal("review.module_type", review.getModule_type());
        }
        if(review.getEntity_id()!=null){
            conds.equal("review.entity_id",review.getEntity_id());
        }
        if(!StringUtils.isEmpty(review.getContent())){
            conds.like("review.content",review.getContent());
        }
        Sort sort = new Sort("review.create_time", OrderType.DESC);

        List<ReviewDto> list = reviewService.fetchSearchByCondsJoinMember(conds, sort, iDisplayStart, iDisplayLength,null);
        Integer counts = reviewService.countMember(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = REVIEW_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            reviewService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

    //是否发布
    @RequiresPermissions(value = REVIEW_EDIT)
    @RequestMapping(value = "/isreleas",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject isreleas( Review review,String st) {
        JSONObject rtnJosn = new JSONObject();
        try {
            if(st.equals("0")){
                review.setStatus("1");
                reviewService.update(review);
            }else{
                review.setStatus("0");
                reviewService.update(review);
            }
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }
}
