package com.cftech.member.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lisw
 * @date: 2017-08-29 13:36
 */
@Data
public class MemberCars implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;

    /*会员名称*/
    @ExportConfig(value = "姓名", width = 100)
    private String memberName;

    /**OPENID/
     */
    private String openId;

    /* 车牌号 */
    @ExportConfig(value = "车牌号", width = 100)
    private String plateNumber;



    /* 品牌ID */
    @ExportConfig(value = "车辆品牌", width = 100)
    private String brandName;
    /* 车系ID */
    @ExportConfig(value = "车辆系列", width = 100)
    private String seriesName;
    /* 车款ID */
    @ExportConfig(value = "车款", width = 100)
    private String carName;

    private String brandLogo;


    /* 会员ID */
    private Long memberId;

    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    @ExportConfig(value = "车款", width = 100,dateFormat="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;



    public MemberCars() {
        this.delFlag = false;
    }
}