package com.cftech.member.dao;

import com.cftech.core.generic.GenericDao;
import com.cftech.core.sql.Conds;
import com.cftech.member.model.Member;
import com.cftech.member.model.MemberDto;
import com.cftech.member.model.MemberVO;

import java.util.List;
import java.util.Map;

/**
* Mapper
*
* @author lisw
* @date: 2017-08-24 17:31
*/
public interface MemberMapper extends GenericDao<Member> {

    /**
     * 分页查询
     *
     * @param params
     * @return
     */
    List<Member> fetchSearchByPageServer(Map<String, Object> params);

    /**
     * 查询总数
     *
     * @return
     */
    int countServer(Map<String, Object> params);

    List<MemberDto> selectmemberDto(Map<String,Object> params);

    int selectmemberDtoCount (Map<String,Object> params);
    /**
     *
     * 个人信息回填
     *
     * @Param
     * @return
     **/
    List<MemberVO> memberFormation(Long id);

    /**
     *
     * 个人信息修改
     *
     * @Param
     * @return
     **/
    int updateMember(MemberVO memberVO);
}