package com.cftech.collection.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * wx_collection 实体类
 * 点赞表
 * Created by mubo 11/05/2017.
 */
@Data
public class CollectionDto implements Serializable {
    /**
     * id
     */
    private Long id;

    /**
     * 服务号或企业号标识
     */
    private Long accountsId;

    /**
     * 被收藏模块枚举
     */
    private String moduleType;

    /**
     * 收藏实体主键
     */
    private Long entityId;

    /**
     * 操作类型枚举
     */
    private String type;

    /**
     * 收藏人
     */
    private String userId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建时间导出字段
     */
    @ExportConfig(value = "收藏时间", width = 200)
    private String createTimeExport;

    /**
     * 记录时效性
     */
    private Boolean delFlag;

    /**
     * 模块名称
     */
    //@ExportConfig(value = "模块名称", width = 100, showLevel = 1)
    private String moduleName;

    /**
     * 名称
     */
    @ExportConfig(value = "名称", width = 100, showLevel = 1)
    private String entityName;


    /**
     * 点赞人姓名
     */
    @ExportConfig(value = "收藏人姓名", width = 100)
    private String userName;

    private String storeId;
    private String storeName;
    private String storeAddress;
    private String price;
    private String img;
    private Date actstarttime;
    private Date actendtime;
    private String signSum;
    private String longitude;
    private String latitude;
    private String isenroll;




    /**
     * 标题
     * */
    private String title;




    public CollectionDto() {
        this.delFlag = false;
    }
}