package com.cftech.core.jwt;

/**
 *  JWT转换时状态处理
 * Created by Jasper Huang on 2018/6/5.
 */
public enum JWTStatus {
    ExpiredJwtException(-1,"TOKEN 过期"), UnsupportedJwtException(-2,"不支持的Token"),
    MalformedJwtException(-3,"格式不正确"), SignatureException(-4,"签名失败"), IllegalArgumentException(-5,"参数异常"),
    CROSSDOMAIN(-6,"跨域请求"),Exception(-9,"未知异常,可能由于OpenId为空"),
    OK(0,"TOKEN 检查成功");
    private int code;
    private String des;
    private JWTStatus(int code,String des) {
        this.setCode(code);
        this.setDes(des);
    }
    public int getCode() {
        return code;
    }
    public void setCode(int code) {
        this.code = code;
    }
    public String getDes() {
        return des;
    }
    public void setDes(String des) {
        this.des = des;
    }
    @Override
    public String toString() {
        return this.code+"_"+this.des;
    }
}
