/**
 * 使用百度图片选择上传器
 * 注意：
 *    需要页面中引用
 *    <script type="text/javascript" charset="utf-8" src="plugins/ueditor-min-1.4.3/ueditor.config.js"></script>
 *    <script type="text/javascript" charset="utf-8" src="plugins/ueditor-min-1.4.3/ueditor.all.js"></script>
 *    这2个js
 */
var ueSPicPicker = (function () {
    'use strict';
    var UESPicPicker = function (params) {
        var p = this;

        //参数定义
        /**
         * tarId: 需要创建一个类似 <script id="upload_ue" type="text/plain"></script>，放在form中
         *        tarId = upload_ue
         * selector: 调用的选择Id或者class，用$()已经封装过
         * success: 回调方法
         * @type {{tarId: string, selector: string, success: function() {} }}
         */
        p.params = {
            tarId: '',
            selector: '',
            className: '',
            success: null
        };

        for (var param in params) {
            p.params[param] = params[param];

        }

        //编辑器
        p.editor = null;
        p.obj = null;


        p.init = function () {
            p.editor  = UE.getEditor(p.params.tarId, {
                toolbars: [[
                    'insertimage']]});
            p.editor.addListener("ready", function () {
                //隐藏编辑器，因为不会用到这个编辑器实例，所以要隐藏
                p.editor.hide();

            });
            initEvents();

        };



        var initEvents = function () {
            //侦听图片上传
            p.editor.addListener('beforeInsertImage', function (t, arg) {
                p.params.success(p.obj, arg);
            });


            p.params.selector.on('click', p.params.className,function () {
                p.obj = $(this);
                var myImage = p.editor.getDialog("insertimage");
                myImage.render();
                myImage.open();
            });
        };




    };

    return UESPicPicker;
})();