package com.cftech.sys.controller;

import com.cftech.core.feature.orm.mybatis.Page;
import com.cftech.core.util.OutputJSONUtil;
import com.cftech.sys.model.Permission;
import com.cftech.sys.model.User;
import com.cftech.sys.model.UserExample;
import com.cftech.sys.security.PermissionSign;
import com.cftech.sys.service.PermissionService;
import com.cftech.sys.service.UserService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 公共视图控制器
 * 
 * @author starzou
 * @since 2014年4月15日 下午4:16:34
 **/
@Controller
@RequestMapping("/a/menu")
public class MenuController {
	
	
	@Autowired
	private UserService userService;
	@Autowired
	private PermissionService permissionService;
    
    //获取数据 
    @ResponseBody
    public void getUsers(int pageNo,int pageSize,HttpServletResponse response)
    {
    	Page<User> page = new Page<>(pageNo, pageSize);
	    UserExample example = new UserExample();
	    example.setOrderByClause("id asc ");
    //	List<User> users=user.selectAllPage(page, example);
    	//OutputJSONUtil.convertoJSONStream(response, JSONArray.fromObject(users).toString());
    }
    
    
    //获得所有树
    @RequiresPermissions(value=PermissionSign.MENU_VIEWS)
    @RequestMapping(value = "menulist",method = {RequestMethod.GET,RequestMethod.POST})
    public String getAllTrue(HttpServletResponse response)
    {
    	return "menus/menulist";
    }
    //保存用户
    //获取数据 
    @RequestMapping(value = "menudata",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public void getMenuList(HttpServletResponse response)
    {
    	JSONObject json = new JSONObject();
    	JSONArray menList = new JSONArray();
    	List<Permission> permissions = permissionService.getMenuTree();
    	for(Permission permission:permissions)
    	{
    		JSONObject tmp = new JSONObject();
    		if(1==permission.getId())
    		{
    			tmp.put("childOuter", false);
    			tmp.put("open", true);
    		}
    		tmp.put("id", permission.getId());
    		tmp.put("pId", permission.getParentid());
    		tmp.put("name", permission.getPermissionName());
    		menList.add(tmp);
    	}
    	json.put("aaData", menList);
    	OutputJSONUtil.convertoJSONStream(response, json.toString()); 
    }
    
    //获得菜单详情
    @RequiresPermissions(value=PermissionSign.MENU_VIEWS)
    @RequestMapping(value = "getMenuDetail",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public void getMenuDetail(HttpServletResponse response,Long id)
    {
    	JSONObject json = new JSONObject();
    	Permission permission = permissionService.selectByPrimaryKey(id);
    	json.put("aaData", JSONObject.fromObject(permission));
    	OutputJSONUtil.convertoJSONStream(response, json.toString()); 
    }

   //新增节点
    @RequiresPermissions(value=PermissionSign.MENU_EDIT)
    @RequestMapping(value = "addNewMenu",method = {RequestMethod.POST})
    @ResponseBody
    public void addNewMenu(HttpServletResponse response,Long parentId)
    {
    	JSONObject json = new JSONObject();
    	Permission permissionParent = permissionService.selectByPrimaryKey(parentId);
    	Permission permission = new Permission();//permissionMapper.selectByPrimaryKey();
    	permission.setParentid(parentId);
    	permission.setIsfunction(0);
    	permission.setIsshow(1);
    	permission.setLongnum(permissionParent.getLongnum()+parentId+",");
    	//插入PERMISSION 
    	permissionService.insertPermission(permission);
    	json.put("aaData", JSONObject.fromObject(permission));
    	OutputJSONUtil.convertoJSONStream(response, json.toString()); 
    }
    
    
    //拖拽MENU
    @RequiresPermissions(value=PermissionSign.MENU_EDIT)
    @RequestMapping(value = "dragMenu",method = RequestMethod.POST)
    @ResponseBody
    public void dragMenu(HttpServletResponse response,Long id,Long parentId)
    {
    	Map<String,Object> map = new HashMap<String,Object>();
    	Permission permissionParent = permissionService.selectByPrimaryKey(parentId);
    	map.put("parentid", parentId);
    	map.put("id", id);
    	map.put("longnum", permissionParent.getLongnum()+id+",");
    	Permission permission =  permissionService.selectByPrimaryKey(id);//permissionMapper.selectByPrimaryKey();
    	map.put("previouslong", permission.getLongnum());
    	//插入PERMISSION 
    	permissionService.updateLevelByPrimaryKey(map);
    	OutputJSONUtil.convertoJSONStream(response, ""); 
    }
    
    //修改MENU 
    //新增节点
    @RequiresPermissions(value=PermissionSign.MENU_EDIT)
    @RequestMapping(value = "updateMenu",method = RequestMethod.POST)
    @ResponseBody
    public void updateMenu(HttpServletResponse response,Permission permission)
    {
    	JSONObject json = new JSONObject();
    	permission.setUpdatetime(new Date());
    	//插入PERMISSION
    	permissionService.updatePermissions(permission);
    	json.put("errorCode", 0);
    	OutputJSONUtil.convertoJSONStream(response, json.toString()); 
    }
    
    /**
     * 删除节点
     */
    @RequiresPermissions(value=PermissionSign.MENU_EDIT)
    @RequestMapping(value = "removeMenu",method = RequestMethod.POST)
    @ResponseBody
    public Object removeMenu(Long id){
    	JSONObject rtnJson = new JSONObject();
    	permissionService.deleteByPrimaryKey(id);
    	rtnJson.put("errorCode", 0);
    	return rtnJson;
    }
    
    
    
}