package com.cftech.showroom.visitorCategory.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 展厅申请来访者类别
 *
 * @author lisw
 * @date: 2019-07-31 15:25
 */
@Data
public class VisitorCategory implements Serializable {

    /* 主键id */
    private Long id;
    /* 编码 */
    private String number;
    /* 类别名称 */
    @ExportConfig(value = "类别名称", width = 100)
    private String name;
    /* 是否需要品牌大使 0:需要  1:不需要 */
    @ExportConfig(value = "是否需要品牌大使 0:需要  1:不需要", width = 100)
    private String isExplainer;

    @ExportConfig(value = "排序值", width = 100)
    private String sort;
    /* 所属的账号 */
    private Long accountsId;
    /* 删除标识 */
    private boolean delFlag;
    /* 状态 */
    private String status;
    /* 创建时间 */
    private Date createTime;
    /* 更新时间 */
    private Date updateTime;
    /* 备注 */
    private String description;
    /* 创建人 */
    private Long createBy;
    /* 更新人 */
    private Long updateBy;

    public VisitorCategory() {
        this.delFlag = false;
        this.status = "0";
    }

}