package com.cftech.cms.special.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.cms.special.model.Special;
import com.cftech.cms.special.service.SpecialService;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.Constants;
import com.cftech.sys.security.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * CMS专题管理Controller
 * <p>
 * 权限字符串说明:
 * 查看:public static final String SPECIAL_VIEW = "qy:special:view"
 * 查看:public static final String SPECIAL_EDIT = "qy:special:edit"
 *
 * @author lisw
 * @date: 2017-05-03 10:21
 */
@Slf4j
@Controller
@RequestMapping("/a/special")
public class SpecialController {

    public static final String SPECIAL_VIEW = "qy:special:view";
    public static final String SPECIAL_EDIT = "qy:special:edit";

    @Autowired
    private SpecialService specialService;


    //列表页面
    @RequiresPermissions(value = SPECIAL_VIEW)
    @RequestMapping(value = "/list", method = {RequestMethod.GET, RequestMethod.POST})
    public String list(HttpServletRequest request, Model model) {
        Long accountId = UserUtils.getmpaccounts(request);
        model.addAttribute("accountId", accountId);
        return "special/speciallist";
    }

    //编辑页面（新增、修改）
    @RequiresPermissions(value = SPECIAL_VIEW)
    @RequestMapping(value = "/form",method = {RequestMethod.GET,RequestMethod.POST})
    public String form(HttpServletRequest request, String id, Model model) {
        if (!StringUtils.isEmpty(id)) {
            Special special = specialService.fetchById(id);
            model.addAttribute("data", special);
        }
        return "special/specialform";
    }

    //提交数据（新增、修改）
    @RequiresPermissions(value = SPECIAL_EDIT)
    @RequestMapping(value = "/formData",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject formData(Special special, Model model, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        JSONObject rtnJson = new JSONObject();
        try {
            if (special != null && special.getId() != null) {
                special.setUpdateBy(UserUtils.getUser().getId());
                specialService.update(special);
                rtnJson.put("errorNo", 0);
            } else {
                special.setAccountsId(accountsId);
                special.setDelFlag(false);
                special.setAccountsId(UserUtils.getmpaccounts(request));
                special.setCreateBy(UserUtils.getUser().getId());
                special.setUpdateBy(UserUtils.getUser().getId());
                specialService.save(special);
                rtnJson.put("errorNo", 2);
            }
        } catch (Exception e) {
            rtnJson.put("errorNo", 1);
        }
        return rtnJson;
    }

    //获取列表数据
    @RequiresPermissions(value = SPECIAL_VIEW)
    @RequestMapping(value = "/listData",method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, Special special, HttpServletRequest request) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("del_flag", Constants.DEL_FLAG_0);
        conds.equal("accounts_id", accountsId);
        if (!StringUtils.isEmpty(special.getName())) {
            conds.like("name", special.getName());
        }
        if (!StringUtils.isEmpty(special.getImg())) {
            conds.like("img", special.getImg());
        }
        if (!StringUtils.isEmpty(special.getRemarks())) {
            conds.like("remarks", special.getRemarks());
        }
        if (!StringUtils.isEmpty(special.getSort())) {
            conds.equal("sort", special.getSort());
        }
        if (!StringUtils.isEmpty(special.getIshow())) {
            conds.equal("ishow", special.getIshow());
        }
        Sort sort = new Sort("create_time", OrderType.DESC);

        List<Special> list = specialService.fetchSearchByPage(conds, sort, iDisplayStart, iDisplayLength);
        Integer counts = specialService.count(conds);
        JSONObject rtnJson = new JSONObject();
        rtnJson.put("iTotalRecords", counts);
        rtnJson.put("iTotalDisplayRecords", counts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //删除数据
    @RequiresPermissions(value = SPECIAL_EDIT)
    @RequestMapping(value = "/delete",method = {RequestMethod.POST})
    @ResponseBody
    public JSONObject delete(String id) {
        JSONObject rtnJosn = new JSONObject();
        try {
            specialService.delete(id);
            rtnJosn.put("errorNo", 0);
        } catch (Exception e) {
            rtnJosn.put("errorNo", 1);
        }
        return rtnJosn;
    }

}
