package com.cftech.base.org.service.impl;

import com.cftech.base.org.dao.QyuserMapper;
import com.cftech.base.org.model.Qyuser;
import com.cftech.base.org.model.vo.QyOrgUserVO;
import com.cftech.base.org.model.vo.QyuserVO;
import com.cftech.base.org.service.QyuserService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * qyuserService
 * Created by Neil 14/02/2017.
 */
@Service("qyuserService")
public class QyuserServiceImpl extends GenericServiceImpl<Qyuser> implements QyuserService {

    /**
     * qyuserMapper
     */
    @Autowired
    @Qualifier("qyuserMapper")
    private QyuserMapper qyuserMapper;

    @Override
    public GenericDao<Qyuser> getGenericMapper() {
        return qyuserMapper;
    }

    @Override
    public List<QyuserVO> fetchSearchVOByPage(Long orgId, Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return qyuserMapper.fetchSearchVOByPage(params);
    }

    @Override
    public List<Qyuser> fetchSearchByPage(Long orgId, Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return qyuserMapper.fetchSearchByPage(params);
    }

    @Override
    public int count(Long orgId, Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("conds", conds);
        return qyuserMapper.count(params);
    }

    @Override
    public void changeStatus(String status, Conds conds) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("status", status);
        qyuserMapper.batchUpdate(params);
    }

    @Override
    public void changeTagIds(String tagIds, Conds conds) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("tagIds", tagIds);
        qyuserMapper.batchUpdate(params);
    }

    @Override
    public void updateStoreInfo(Long id, String role, Long storeId, String storeName) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("role", role);
        params.put("storeId", storeId);
        params.put("storeName", storeName);
        qyuserMapper.updateStoreInfo(params);
    }

    @Override
	public List<QyuserVO> getSubordinateUser(Long positionId,Long orgId,Long userId,Long accountsId,int page,int pageSize,Sort sort,String name) {
		Map<String,Object> params = new HashMap<String, Object>();
		params.put("positionId",positionId);
		params.put("orgId",orgId);
		params.put("userId",userId);
		params.put("accountsId", accountsId);
		params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        params.put("name", name);
		return qyuserMapper.getSubordinateUser(params);
	}

    @Override
    public void appendTagids(String tagIds, Conds conds) {
        Map<String, Object> params = new HashMap<>();
        params.put("conds", conds);
        params.put("tagIds", tagIds);
        qyuserMapper.appendTagids(params);
    }

	@Override
	public List<QyOrgUserVO> getOrgSubordinateUser(Map<String, Object> params) {
		return qyuserMapper.getOrgSubordinateUser(params);
	}

	@Override
	public List<Qyuser> getOrgUserList(Map<String, Object> params) {
		return qyuserMapper.getOrgUserList(params);
	}

    @Override
    public List<Qyuser> findUsersByTagIds(Long accountsId, String delFlag, String regTagIds) {
        Map<String, Object> params = new HashMap<>();
        params.put("accountsId", accountsId);
        params.put("delFlag", delFlag);
        params.put("tagIds", regTagIds);
        return qyuserMapper.findUsersByTagIds(params);
    }

    @Override
    public  List<Qyuser> getLogInfo(Map<String, Object> params)
    {
        return qyuserMapper.getLogInfo(params);
    }

    @Override
    public List<Qyuser> fetchPollingData(String type) {
        //判断是否为复购
        return qyuserMapper.fetchPollingData(type);
    }

    @Override
    public boolean updateAssigned(Qyuser user) {
        return qyuserMapper.updateAssigned(user);
    }
}
