package com.cftech.questionnaire.core.paperstatic.service.impl;

import com.cftech.core.sql.Sort;
import com.cftech.questionnaire.core.paperstatic.model.Paperstatic;
import com.cftech.questionnaire.core.paperstatic.dao.PaperstaticMapper;
import com.cftech.questionnaire.core.paperstatic.service.PaperstaticService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* ServiceImpl
*
* @author byj
* @date: 2018-07-28 14:14
*/
@Service("paperstaticService")
public class PaperstaticServiceImpl extends GenericServiceImpl<Paperstatic> implements PaperstaticService {

@Autowired
@Qualifier("paperstaticMapper")
private PaperstaticMapper paperstaticMapper;

@Override
public GenericDao<Paperstatic> getGenericMapper() {
return paperstaticMapper;
}

    @Override
    public List<Paperstatic> fetchSearchByPageCountList(Conds conds, Sort sort, int page, int pageSize, Long paperId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        params.put("paperId", paperId);
        return paperstaticMapper.fetchSearchByPageCountList(params);
    }
}