package com.cftech.collection.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.collection.model.CollectionDto;
import com.cftech.collection.service.CollectionService;
import com.cftech.core.poi.ExcelKit;
import com.cftech.core.scope.OrderType;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.core.util.StringUtils;
import com.cftech.sys.security.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.List;

/**
 * 权限字符串说明:
 * 查看:public static final String COLLECTION_VIEW = "collection:view"
 * 查看:public static final String COLLECTION_EDIT = "collection:edit"
 * collectionWeb
 * Created by mubo 11/05/2017.
 */
@Controller
@RequestMapping("/a/collection")
public class CollectionController {

    /**
     * collectionService
     */
    public static final String COLLECTION_VIEW = "collection:view";
    public static final String COLLECTION_EDIT = "collection:edit";
    @Autowired
    private CollectionService collectionService;

    //返回列表页面
    @RequiresPermissions(value = COLLECTION_VIEW)
    @RequestMapping(value = "/list",method = {RequestMethod.GET,RequestMethod.POST})
    public String list(Model model, HttpServletRequest request , Long id , String moduleType) {
        model.addAttribute("id",id);
        model.addAttribute("moduleType",moduleType);
        return "collection/collectionlist";
    }

    //获取列表数据
    @RequiresPermissions(value = COLLECTION_VIEW)
    @RequestMapping(value = "/listData", method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public JSONObject listData(int iDisplayStart, int iDisplayLength, CollectionDto collectionDto, HttpServletRequest request) throws Exception {
        JSONObject rtnJson = new JSONObject();
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("c.del_flag", 0);
        conds.equal("c.accounts_id", accountsId);
        if(StringUtils.isNotBlank(collectionDto.getUserName())) {
            conds.like("m.name",collectionDto.getUserName());
        }

        if(StringUtils.isNoneBlank(String.valueOf(collectionDto.getEntityId()))){
            conds.equal("c.entity_id",collectionDto.getEntityId());
        }
        if(StringUtils.isNoneBlank(collectionDto.getModuleType())){
            conds.equal("c.module_type",collectionDto.getModuleType());
        }
        Sort sort = new Sort("c.create_time", OrderType.DESC);
        List<CollectionDto> list = collectionService.findCollectionByPageVo(conds, sort, iDisplayStart, iDisplayLength,collectionDto.getEntityName(),collectionDto.getUserName());
        Integer userCounts = collectionService.findCollectionByPageVoCount(conds,collectionDto.getEntityName());
        rtnJson.put("iTotalRecords", userCounts);
        rtnJson.put("iTotalDisplayRecords", userCounts);
        rtnJson.put("aaData", list);
        return rtnJson;
    }

    //导出数据
    @RequiresPermissions(value = COLLECTION_EDIT)
    @RequestMapping(value = "/exportListData", method = {RequestMethod.GET,RequestMethod.POST})
    @ResponseBody
    public void cardFetechData(CollectionDto collectionDto, HttpServletRequest request, HttpServletResponse response) {
        Long accountsId = UserUtils.getmpaccounts(request);
        Conds conds = new Conds();
        conds.equal("c.del_flag", false);
        conds.equal("c.accounts_id", accountsId);
        if(StringUtils.isNotBlank(collectionDto.getUserName())) {
            conds.like("member.name",collectionDto.getUserName());
        }
        if(StringUtils.isNotBlank(collectionDto.getModuleType())) {
            conds.equal("c.module_type",collectionDto.getModuleType());
        }
        Sort sort = new Sort("c.create_time", OrderType.DESC);
        List<CollectionDto> list = collectionService.findCollectionByPageVo(conds, sort, 0, 0,collectionDto.getEntityName(),collectionDto.getUserName());
        try {
            ExcelKit.$Export(CollectionDto.class, response).toExcel(formatDateToExport(list), "收藏记录");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    /**
     * 构造导出数据
     * */
    private List<CollectionDto> formatDateToExport(List<CollectionDto> data){
        for (CollectionDto collectionDto:data) {
            String moduleNameTemp="";
            if(collectionDto.getModuleType()!= null){
                switch (collectionDto.getModuleType()){
                    case "1":
                        moduleNameTemp="车型";
                        break;
                    case "2":
                        moduleNameTemp="文章";
                        break;
                    case "3":
                        moduleNameTemp="活动";
                        break;
                    default:
                        moduleNameTemp = "";
                        break;
                }
                collectionDto.setModuleName(moduleNameTemp);
            }
            if(collectionDto.getCreateTime()!=null){
                collectionDto.setCreateTimeExport(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(collectionDto.getCreateTime()));
            }
        }
        return data;
    }

}