package com.cftech.brand.material.service.impl;

import com.cftech.brand.material.model.BrandMaterial;
import com.cftech.brand.material.dao.BrandMaterialMapper;
import com.cftech.brand.material.service.BrandMaterialService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* 类别ServiceImpl
*
* @author faye
* @date 2020/01/14
*/
@Service("brandMaterialService")
public class BrandMaterialServiceImpl extends GenericServiceImpl<BrandMaterial> implements BrandMaterialService {

@Autowired
@Qualifier("brandMaterialMapper")
private BrandMaterialMapper brandMaterialMapper;

@Override
public GenericDao<BrandMaterial> getGenericMapper() {
return brandMaterialMapper;
}

    @Override
    public List<BrandMaterial> fetchSearchByPageVo(Conds conds, Sort sort, int page, int pageSize) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        return brandMaterialMapper.fetchSearchByPageVo(params);
    }
}