package com.cftech.brand.department.service.impl;

import com.cftech.brand.department.model.BrandDepartment;
import com.cftech.brand.department.dao.BrandDepartmentMapper;
import com.cftech.brand.department.service.BrandDepartmentService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/**
* 部门ServiceImpl
*
* @author faye
* @date 2020/01/14
*/
@Service("brandDepartmentService")
public class BrandDepartmentServiceImpl extends GenericServiceImpl<BrandDepartment> implements BrandDepartmentService {

@Autowired
@Qualifier("brandDepartmentMapper")
private BrandDepartmentMapper brandDepartmentMapper;

@Override
public GenericDao<BrandDepartment> getGenericMapper() {
return brandDepartmentMapper;
}

    @Override
    public String getNamesByIds(String ids) {
        return brandDepartmentMapper.getNamesByIds(ids);
    }

    @Override
    public String getIdsByNumbers(String numbers) {
        return brandDepartmentMapper.getIdsByNumbers(numbers);
    }

}