package com.cftech.brand.category.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 分类
 *
 * @author faye
 * @date 2020/01/14
 */
@Data
public class BrandCategory implements Serializable {

    /** 主键id */
    private Long id;
    /** 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /** 名称 */
    @ExportConfig(value = "名称", width = 100)
    private String name;
    /** 所属部门ids */
    private String departmentId;

    @ExportConfig(value = "所属部门", width = 100)
    private String departmentNumber;

    private String departmentName;

    /** 所属的账号 */
    private Long accountsId;
    /** 删除标识 */
    private boolean delFlag;
    /** 状态 */
    private String status;
    /** 创建时间 */
    private Date createTime;
    /** 更新时间 */
    private Date updateTime;
    /** 备注 */
    private String description;
    /** 创建人 */
    private Long createBy;
    /** 更新人 */
    private Long updateBy;

    public BrandCategory() {
        this.delFlag = false;
        this.status = "0";
    }

}