package com.cftech.brand.apply.detail.model;

import com.cftech.core.poi.ExportConfig;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 品牌申请详情
 *
 * @author faye
 * @date 2020/01/15
 */
@Data
public class BrandApplyDetail implements Serializable {

    /** 主键id */
    private Long id;
    /** 编码 */
    @ExportConfig(value = "编码", width = 100)
    private String number;
    /** 申请单Id */
    @ExportConfig(value = "申请单Id", width = 100)
    private Long applyId;
    /** 物料id */
    @ExportConfig(value = "物料id", width = 100)
    private Long materialId;
    /** 数量 */
    @ExportConfig(value = "数量", width = 100)
    private Integer quantity;
    /** 所属的账号 */
    private Long accountsId;
    /** 删除标识 */
    private boolean delFlag;
    /** 状态 */
    private String status;
    /** 创建时间 */
    private Date createTime;
    /** 更新时间 */
    private Date updateTime;
    /** 备注 */
    private String description;
    /** 创建人 */
    private Long createBy;
    /** 更新人 */
    private Long updateBy;

    public BrandApplyDetail() {
        this.delFlag = false;
        this.status = "0";
    }

}