package com.cftech.review.service.impl;


import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import com.cftech.review.dao.ReviewMapper;
import com.cftech.review.model.Review;
import com.cftech.review.service.ReviewService;
import com.cftech.review.vo.ReviewDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 评论ServiceImpl
 *
 * @author lisw
 * @date: 2017-05-11 10:31
 */
@Service("reviewService")
public class ReviewServiceImpl extends GenericServiceImpl<Review> implements ReviewService {

    @Autowired
    @Qualifier("reviewMapper")
    private ReviewMapper reviewMapper;


    @Override
    public GenericDao<Review> getGenericMapper() {
        return reviewMapper;
    }

    @Override
    public int countMember(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return reviewMapper.countMember(params);
    }

    @Override
    public List<ReviewDto> fetchSearchByCondsJoinMember(Conds conds, Sort sort, int page, int pageSize, String openId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        params.put("openId", openId);
        return reviewMapper.fetchSearchByPageJoinMember(params);
    }

    //评论成功后更新展会表里面的数据
    @Override
    public void updateexhibi(Review review) {
        Map param = new HashMap();
        try {
            if(review.getModule_type().equals("0")){ //展会模块
                param.put("id",review.getEntity_id());
                param.put("count",1);
                reviewMapper.updateexhibi(param);
            }
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}