package com.cftech.base.org.dao;

import com.cftech.base.org.model.OrgUnit;
import com.cftech.base.org.model.vo.OrgUnitVO;
import com.cftech.core.generic.GenericDao;

import java.util.List;
import java.util.Map;


public interface OrgUnitMapper extends GenericDao<OrgUnit> {

	List<OrgUnit> findAllChildren(Long orgId);

	List<OrgUnit> findAllByAccountId(Long accountId);

	/**
	 * <p>把组织移动至另一个组织下</p>
	 * @param map
	 * @return 移动成功或失败
	 */
	boolean move(Map<String, Object> map);

    List<OrgUnitVO> fetchSearchVOByPage(Map<String, Object> params);

    void changeStatus(Map<String, Object> params);
    
    /**
	 * 根据员工ID查询对应下属组织
	 */
	List<OrgUnit> fetchSearchByOrgUnit(Map<String, Object> params);

}
