package com.cftech.qy.qyagent.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cftech.base.org.api.WxApiUtils;
import com.cftech.core.sql.Conds;
import com.cftech.core.util.QyTokenUtil;
import com.cftech.qy.qyagent.model.Qyagent;
import com.cftech.qy.qyagent.service.QyagentService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Created by liuling on 2017/4/26.
 * 企业号企业应用同步
 */

@Slf4j
@Component
public class QyAgentUtil {

    @Autowired
    private QyTokenUtil qyTokenUtil;
    @Autowired
    private QyagentService qyagentService;

    public JSONObject sync(Long accountId, Long user) {
        JSONObject retObj = new JSONObject();
        int successCreateCount = 0;
        int successUpdateCount = 0;

        //微信端的所有应用
        JSONObject agentRetObj = WxApiUtils.agentList(qyTokenUtil.getToken(accountId));
        if (agentRetObj.getIntValue("errcode") == 0) {
            clearStatus(accountId);
            //获取成功
            JSONArray agentList = agentRetObj.getJSONArray("agentlist");
            for (int i = 0, j = agentList.size(); i < j; i++) {
                JSONObject agentObj = agentList.getJSONObject(i);
                String agentid = agentObj.getString("agentid");

                Qyagent qyagent = findByAgentId(accountId, agentid);

                if (qyagent == null) {
                    // 新增
                    qyagent = new Qyagent();
                    qyagent.setAccountsId(accountId);
                    qyagent.setAgentId(agentObj.getString("agentid"));
                    qyagent.setName(agentObj.getString("name"));
                    qyagent.setSquareLogo(agentObj.getString("square_logo_url"));
                    qyagent.setRoundLogo(agentObj.getString("round_logo_url"));
                    qyagent.setStatus("0");
                    qyagent.setCreateBy(user);
                    qyagent.setUpdateBy(user);
                    qyagentService.save(qyagent);
                    successCreateCount++;
                } else {
                    // 更新
                    qyagent.setName(agentObj.getString("name"));
                    qyagent.setSquareLogo(agentObj.getString("square_logo_url"));
                    qyagent.setRoundLogo(agentObj.getString("round_logo_url"));
                    qyagent.setStatus("0");
                    qyagent.setUpdateBy(user);
                    qyagentService.update(qyagent);
                    successUpdateCount++;
                }
            }
        }
        retObj.put("successCreateCount", successCreateCount);
        retObj.put("successUpdateCount", successUpdateCount);
        return retObj;
    }

    public void clearStatus(Long accountId) {
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        String status = "3"; //同步中
        qyagentService.changeStatus(status, conds);
    }

    public Qyagent findByAgentId(Long accountId, String agentId) {
        Conds conds = new Conds();
        conds.equal("del_flag", 0);
        conds.equal("accounts_id", accountId);
        conds.equal("agent_id", agentId);
        return qyagentService.fetchSearchByConds(conds);
    }
}
