package com.cftech.addresst.web;

import com.alibaba.fastjson.JSONObject;
import com.cftech.addresst.model.Address;
import com.cftech.addresst.model.Area;
import com.cftech.addresst.service.AddressService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;

/**
 * @author ：licc
 * @date ：Created in 2020/10/19 18:11
 * @description：收货地址
 */
@Slf4j
@RestController
@CrossOrigin
@RequestMapping("mobile/auth/address")
public class MobileAddressController {
    @Autowired
    private AddressService addressService;


    /**
     * @return
     * @Description 个人收货地址数据回填
     * @Date 9:53 2020/10/20
     * @Param
     **/
    @RequestMapping(value = "/addressList", method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject addressList(String openId,String appId) {
        return addressService.addressList(openId,appId);
    }

    /**
     * @return
     * @Description 根据id查询收货地址
     * @Date 9:53 2020/10/20
     * @Param
     **/
    @RequestMapping(value = "/addressId", method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject addressId(Long id,String appId) {
        return addressService.addressId(id,appId);
    }

    /**
     * @return
     * @Description 省市区信息回填
     * @Date 9:53 2020/10/20
     * @Param
     **/
    @RequestMapping(value = "/listArea", method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject listArea(String appId) {
        JSONObject rtnJson = new JSONObject();
        try {

            List<Area> areas = addressService.listArea();
            if (!areas.equals("") || areas != null) {
                rtnJson.put("errorNo", "0");
                rtnJson.put("data", areas);
            }
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNO", "1");
        }

        return rtnJson;
    }

    /**
     * @return
     * @Description 个人收货地址新增
     * @Date 9:53 2020/10/20
     * @Param
     **/
    @RequestMapping(value = "/addressAdd", method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject addressAdd(Address address) {
        return addressService.addressAdd(address);
    }

    /**
     * @return
     * @Description 收货地址修改
     * @Date 15:19 2020/10/20
     * @Param
     **/
    @RequestMapping(value = "/updateAddress", method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject updateAddress(Address address) {
        return addressService.updateAddress(address);
    }

    /**
     * @return
     * @Author Licc
     * @Description 收货地址删除
     * @Date 15:52 2020/10/20
     * @Param
     **/
    @RequestMapping(value = "/deleteAddress", method = {RequestMethod.GET, RequestMethod.POST}, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public JSONObject deleteAddress(String id,String appId) {
        return addressService.deleteAddress(id,appId);
    }


}
