package com.cftech.cms.cfarticle.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cftech.accounts.model.MpAccountsEntity;
import com.cftech.accounts.service.MpAccountsService;
import com.cftech.cms.cfarticle.dao.CfarticleMapper;
import com.cftech.cms.cfarticle.model.Cfarticle;
import com.cftech.cms.cfarticle.model.CfarticleColumnDto;
import com.cftech.cms.cfarticle.model.CfarticleVO;
import com.cftech.cms.cfarticle.model.columnVO;
import com.cftech.cms.cfarticle.service.CfarticleService;
import com.cftech.core.generic.GenericDao;
import com.cftech.core.generic.GenericServiceImpl;
import com.cftech.core.sql.Conds;
import com.cftech.core.sql.Sort;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CMS文章管理ServiceImpl
 *
 * @author lisw
 * @date: 2017-05-03 10:51
 */
@Service("cfarticleService")
public class CfarticleServiceImpl extends GenericServiceImpl<Cfarticle> implements CfarticleService {

    @Autowired
    @Qualifier("cfarticleMapper")
    private CfarticleMapper cfarticleMapper;
    @Autowired
    private MpAccountsService mpAccountsService;
    @Override
    public GenericDao<Cfarticle> getGenericMapper() {
        return cfarticleMapper;
    }

    @Override
    public List<CfarticleColumnDto> fetchSearchByPageTemp(Conds conds, Sort sort, int page, int pageSize, Long specialId) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("offset", page > 0 ? page : 0);
        params.put("limit", pageSize > 0 ? pageSize : 0);
        params.put("sort", sort);
        params.put("specialId", specialId);
        return cfarticleMapper.fetchSearchByPageTemp(params);
    }

    @Override
    public int countTemp(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return cfarticleMapper.countTemp(params);
    }

    @Override
    public List<Cfarticle> fetchSearchByPageInOrder(Conds conds, String articles) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        params.put("articles", articles);
        return cfarticleMapper.fetchSearchByPageInOrder(params);
    }

    @Override
    public int countReview(Conds conds) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("conds", conds);
        return cfarticleMapper.countReview(params);
    }

    @Override
    public JSONObject updatecom(String datas) {
        JSONObject rtnJson = new JSONObject();
        datas = datas.replaceAll("&quot;", "\"");
        JSONArray jsonArray = JSONArray.fromObject(datas);
        if (jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); i++) {
                net.sf.json.JSONObject jsonObject = jsonArray.getJSONObject(i);
                long id = jsonObject.getLong("id");
                long recommended = jsonObject.getLong("recommended");
                long whetherBanner = jsonObject.getLong("whetherBanner");
                Integer integer = cfarticleMapper.updatecom(id, recommended, whetherBanner);
                if (integer > 0) {
                    rtnJson.put("errorNo", "0");
                    rtnJson.put("errorMsg", "修改成功");
                }

            }
        }
        return rtnJson;
    }

    @Override
    public JSONObject recommended(Long id,String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            List<CfarticleVO> recommended = cfarticleMapper.recommended(id);
            if (recommended.size()>0) {
                rtnJson.put("errorNo", "0");
                rtnJson.put("data", recommended);
                return rtnJson;
            }
            rtnJson.put("errorNo", "1");
            rtnJson.put("errorMsg", "查询失败");
        } catch (Exception e) {
            e.printStackTrace();
            rtnJson.put("errorNo", "1");
            rtnJson.put("errorMsg", "系统异常");
        }

        return rtnJson;
    }
    @Transactional(rollbackFor = Exception.class)
    @Override
    public JSONObject reading(Long id,String appId) {
        JSONObject rtnJson = new JSONObject();
        int count = 1;
        try {
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            CfarticleVO reading = cfarticleMapper.saveReading(id);
            Long recommended = reading.getRecommended();
            Long redings = reading.getReading();
            if (redings==null){
                count+=0;
            }else{
                count+=redings;
            }
            Integer integer = cfarticleMapper.reading(id,count);
            if (integer>0){
                CfarticleVO saveReading = cfarticleMapper.saveReading(id);
                rtnJson.put("errorNo", "0");
                rtnJson.put("data", saveReading.getReading());
            }
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo", "1");
            rtnJson.put("errorMsg", "系统异常");
        }
        return rtnJson;
    }

    @Override
    public JSONObject geteway(String title,String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            List<Cfarticle> cfarticles = cfarticleMapper.gateway(title);
            if (cfarticles==null){
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg","查询失败");
                return  rtnJson;
            }
            rtnJson.put("errorNo", "0");
            rtnJson.put("errorMsg",cfarticles);

        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo", "1");
            rtnJson.put("errorMsg", "系统异常");
        }
        return rtnJson;
    }

    @Override
    public JSONObject column(String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            List<columnVO> column = cfarticleMapper.column();
            if (column==null){
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg","查询失败");
                return rtnJson;
            }
            rtnJson.put("errorNo", "0");
            rtnJson.put("errorMsg",column);

        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo", "1");
            rtnJson.put("errorMsg", "系统异常");
        }
        return rtnJson;
    }

    @Override
    public JSONObject columnDetails(Long id,String appId) {
        JSONObject rtnJson = new JSONObject();
        try {
            MpAccountsEntity mpAccountsAppid = mpAccountsService.getMpAccountsAppid(appId);
            List<CfarticleVO> cfarticleVOS = cfarticleMapper.columnDetails(id);
            if (cfarticleVOS==null){
                rtnJson.put("errorNo", "1");
                rtnJson.put("errorMsg","查询失败");
                return  rtnJson;
            }
            rtnJson.put("errorNo", "0");
            rtnJson.put("errorMsg",cfarticleVOS);
        }catch (Exception e){
            e.printStackTrace();
            rtnJson.put("errorNo", "1");
            rtnJson.put("errorMsg", "系统异常");
        }
        return rtnJson;
    }


    @Override
    public JSONObject selectYes() {
        JSONObject rtnJson = new JSONObject();
        Integer integer = cfarticleMapper.selectcom();

        rtnJson.put("errorNo", "0");
        rtnJson.put("data",integer);
        return rtnJson;
    }

    @Override
    public JSONObject selectBanner() {
        JSONObject rtnJson = new JSONObject();
        Integer banner = cfarticleMapper.selectBanner();

        rtnJson.put("errorNo", "0");
        rtnJson.put("data",banner);
        return rtnJson;
    }

}